/* ibm.c: Miscellaneous IBM-PC code

Known WinArcadia bugs:
 (*) Sometimes moving the mouse when paused causes the emulation to run
     for a rastline.
*/

// always define one (only!) of these. Normally MODE_FPS (it's more useful!)
#define MODE_FPS
// #define MODE_CPS

// always define one (only!) of these. Normally MODE_DEEP (it's faster!)
#define MODE_DEEP
// #define MODE_SHALLOW

/* Deep mode is 32 bits per pixel. Shallow mode is 8 bits per pixel.
It would be possible to have a "very shallow" mode which would use only
4 bits per pixel, saving more memory, but this would presumably be even
slower. */

#include "ibm.h"

#include <commctrl.h>
#include "resource.h"

#include <stdio.h>
#include <fcntl.h> // for _O_TEXT
#include <io.h>    // for _open_osfhandle()

#include "aa.h"

const char g_szClassName[] = "WinArcadia";

#define IDC_TOOLBAR       102
#define IDC_FPS           103
#define IDC_STATIC        104

#define REGION_NTSC         0
#define REGION_PAL          1

#define DLGTYPE_BP          0
#define DLGTYPE_WP          1

#define KIND_BP             0
#define KIND_WP             1

#define A_TITLEBARTEXT     "WinArcadia 4.32"
#define I_TITLEBARTEXT     "WinInterton 4.32"
#define E_TITLEBARTEXT     "WinElektor 4.32"
#define TITLEBARTEXTLENGTH 23 // 23 is enough for "WinInterton x.xxx: "

#define CONFIGLENGTH       28 // in bytes, counting from 1 (data is 0..CONFIGLENGTH-1)
                              // (not including game path)

#define SMALLGADGETS       22
#define SMALLIMAGES        16

EXPORT int    controlstype,
              monitortype,
              winleftx,
              wintopy,
              titleheight;
EXPORT FLAG   step             = FALSE,
              psgplaying[14]   = {FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE,
                                  FALSE, FALSE, FALSE, FALSE, FALSE, FALSE, FALSE};
EXPORT ULONG  oldframes,
              newclock;
EXPORT UBYTE  screen[BOXWIDTH][BOXHEIGHT];
EXPORT HWND   ControlsWindowPtr = NULL,
              MainWindowPtr     = NULL,
              MonitorWindowPtr  = NULL,
              hToolbar          = NULL;
EXPORT HMENU  MenuPtr           = NULL;
EXPORT TEXT   globalstring[13 + 1 + 1];
EXPORT UBYTE  oldkeys[KEYS];

EXPORT ULONG  pens[16] =
{   0x00FFFFFF,
    0x00FFFF00,
    0x0000FFFF,
    0x0000FF00,
    0x00FF00FF,
    0x00FF0000,
    0x000000FF,
    0x00000000,
    0x00000000,
    0x00000088,
    0x00008800,
    0x00008888,
    0x00880000,
    0x00880088,
    0x00888800,
    0x00888888
};

#ifdef MODE_SHALLOW
    #define EVENBOXWIDTH 152 // must be a multiple of 4 ("Each scan line must be padded with zeroes to end on a LONG data-type boundary.")
    // Note that this could be calculated algorithmically from BOXWIDTH, but it is not!
    // Therefore if BOXWIDTH is changed, EVENBOXWIDTH must be changed also.
#endif

#ifdef MODE_SHALLOW
    EXPORT UBYTE     display[EVENBOXWIDTH * BOXHEIGHT];
#else
    EXPORT int       display[BOXWIDTH * BOXHEIGHT];
#endif

MODULE char        bitmapbuffer[sizeof(BITMAPINFO) + 16];
MODULE BITMAPINFO* BitmapHeaderPtr;
MODULE FLAG        joy[2];
MODULE UBYTE     KeyMatrix[64], // to allow keycodes up to 511
                 realsize,
                 realwide,
                 ConfigBuffer[CONFIGLENGTH];
MODULE TEXT      ProgDir[MAX_PATH + 1] = "",
              // arg[MAX_PATH + 1 + 5], // the + 5 is for "FILE="
                 fpsstring[10 + 1],
                 titlebartext[MAX_PATH + 1 + TITLEBARTEXTLENGTH];
MODULE HWND      LabelPtr          = NULL,
                 FPSPtr            = NULL;
MODULE HGDIOBJ   OldObject         = NULL;
// MODULE HANDLE AcceleratorPtr    = NULL;
MODULE HINSTANCE InstancePtr       = NULL;
MODULE int       DisplayWidth,
                 DisplayHeight,
                 xoffset,
                 yoffset,
                 stretchyoffset,
                 clientheight,
                 menuheight,
                 bpl,
                 dlgtype;
MODULE ULONG     fps               = 0,
                 oldfps            = ~0,
                 newtime,
                 oldtime;
MODULE SWORD     rastwidth,
                 rastheight;
MODULE RECT      therect;
MODULE DWORD     winwidth,
                 winheight;
MODULE ULONG     waittill          = 0;

// IMPORTED VARIABLES ----------------------------------------------------

// ReAction gadgets
IMPORT ULONG     analog,
                 autofire,
                 collisions,
                 demultiplex,
                 flagline,
                 paused,
                 sound,
                 swapped,
                 warp,
                 region,
                 vlock;
// other ULONGs here
IMPORT ULONG     elapsed,
                 frames;
IMPORT FLAG      autosave,
                 consoleopen,
                 crippled,
                 emulating,
                 fullscreen,
				 limitrefresh,
                 loginstructions,
                 logreads,
                 logwrites,
                 loop,
                 runtorastline,
                 runtodma,
                 runtoframe,
			     showmenubar,
                 showpointer,
                 showtitlebar,
                 showtoolbar,
                 stretch,
                 trace,
				 usehacks,
                 watchreads;
IMPORT UWORD     iar;
IMPORT UBYTE     memory[32768];
IMPORT FLAG      game;
IMPORT int       bp,
                 fromnum,
                 machine,
                 rastn,
                 recmode,
                 sensegame,
                 size,
                 tonum,
                 tolimit,
                 wide,
                 wp;
IMPORT TEXT      filepart[MAX_PATH + 1], // file only
                 friendly[21 + 1],
                 fromstr[5 + 1 + 1],
                 pathpart[MAX_PATH + 1],
                 thefilename[MAX_PATH + 1], // the entire pathname (path and file)
                 tostr[5 + 1 + 1];

// MODULE ARRAYS ---------------------------------------------------------

MODULE int menucode[MENUITEMS] =
{   ID_OPTIONS_CONTROLLERS_ANALOG,   //  0
    ID_OPTIONS_CONTROLLERS_AUTOFIRE,
    ID_OPTIONS_AUTOSAVE,
    ID_DEBUG_CHANGE,
    ID_DEBUG_CLEARBP,
    ID_DEBUG_CLEARWP,                //  5
    ID_OPTIONS_SPRITES_COLLISIONS,
    ID_VIEW_CRAM,
    -1, // create icons
    ID_OPTIONS_SPRITES_DEMULTIPLEX,
    ID_OPTIONS_GRAPHICS_FLAGLINE,    // 10
    ID_OPTIONS_GRAPHICS_FULLSCREEN,
    -1, // help
    -1, // joy1
    ID_OPTIONS_SPEED_LIMITREFRESH,
    ID_DEBUG_LOGINSTRUCTIONS,        // 15
    ID_DEBUG_LOGREADS,
    ID_DEBUG_LOGWRITES,
    ID_MACRO_LOOP,
    -1, // machine
    -1, // macro                     // 20
    ID_VIEW_MENU,
    ID_VIEW_MONITOR,
    ID_OPTIONS_GRAPHICS_NARROW,
    ID_FILE_OPEN,
    ID_OPTIONS_SPEED_PAUSED,         // 25
    ID_VIEW_POINTER,
    -1, // region
    ID_FILE_RESET,
    ID_DEBUG_RUNTODMA,
    ID_DEBUG_RUNTOFRAME,             // 30
    ID_DEBUG_RUNTORASTLINE,
    ID_DEBUG_RUNTORASTN,
    ID_FILE_SAVESNP,
    ID_FILE_SAVEROM,
    ID_DEBUG_SETBP,                  // 35
    ID_DEBUG_SETWP,
    -1, // size
    ID_OPTIONS_SOUND,
    ID_DEBUG_STEP,
    ID_OPTIONS_GRAPHICS_STRETCH,     // 40
    ID_OPTIONS_CONTROLLERS_SWAPPED,
    ID_VIEW_TITLE,
    ID_VIEW_TOOL,
    ID_DEBUG_TRACECPU,
    ID_OPTIONS_GRAPHICS_VLOCK,       // 45
    ID_OPTIONS_SPEED_WARP,
    ID_VIEW_ALLMEMORY,
    ID_FILE_SAVETVC,
    ID_VIEW_CONTROLS,
    ID_DEBUG_WATCHREADS,             // 50
    ID_VIEW_PSGS,
    ID_VIEW_LOWERSCREEN,
    ID_FILE_RESETTOMONITOR,
    -1, // sensegame
    ID_MACHINE_USEHACKS              // 55
};
MODULE int gadgetcode[] =
{   ID_OPTIONS_GRAPHICS_FLAGLINE,    //  0
    ID_OPTIONS_GRAPHICS_VLOCK,
    ID_OPTIONS_CONTROLLERS_ANALOG,
    ID_OPTIONS_CONTROLLERS_AUTOFIRE,
    -1, // joy1
    ID_OPTIONS_CONTROLLERS_SWAPPED,  //  5
    ID_OPTIONS_SPEED_PAUSED,
    ID_OPTIONS_SPEED_WARP,
    ID_OPTIONS_SPEED_REGION,
    ID_OPTIONS_SPRITES_COLLISIONS,
    ID_OPTIONS_SPRITES_DEMULTIPLEX,  // 10
    ID_OPTIONS_SOUND,
    -1 // macro                      // 12
};

BOOL CALLBACK ControlsDlgProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK HelpDlgProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK MonitorDlgProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK SetDlgProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK RastNDlgProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK ChangeDlgProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam);
MODULE void project_open(void);
MODULE __inline void thewait(void);
MODULE void freeall(void);
MODULE void calcsize(FLAG autosize);
MODULE void resize(int newsize);
MODULE void maketoolbar(HWND hwnd);
MODULE FLAG ctrl(void);
MODULE FLAG shift(void);
MODULE void printusage(STRPTR progname);
MODULE void debug_set(int kind);
MODULE void debug_setrastn(void);
MODULE void debug_change(void);
MODULE void split(void);
MODULE void handlekybd(UINT code);
MODULE void clearkybd(void);
MODULE void drawpixel(SLONG x, SLONG y, UBYTE colour);

LRESULT CALLBACK WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{   PAINTSTRUCT   ps;
    int           i;
 // int           iToolHeight;
    LPTOOLTIPTEXT lpttt;

    switch(msg)
    {   case WM_CREATE:
            maketoolbar(hwnd);
        break;
/*      case WM_SYSCOMMAND:
            if (wParam == SC_MAXIMIZE)
            {   if (fullscreen) fullscreen = FALSE; else fullscreen = TRUE;
                updatemenu(MENUITEM_FULLSCREEN);
                closewindow();
                openwindow(TRUE);
                redrawscreen();
            } else
            {   return DefWindowProc(hwnd, msg, wParam, lParam);
            }
        break; */
        case WM_NCLBUTTONDBLCLK:
            if (fullscreen) fullscreen = FALSE; else fullscreen = TRUE;
            updatemenu(MENUITEM_FULLSCREEN);
            closewindow();
            openwindow(TRUE);
            redrawscreen();
        break;
        case WM_DROPFILES:
            DragQueryFile((HDROP) wParam, 0, thefilename, MAX_PATH);
            DragFinish((HDROP) wParam);
            // runtime_// assert(strlen(thefilename) <= MAX_PATH);
            engine_load();
        break;
        case WM_PAINT:
            BeginPaint(hwnd, &ps);
            redrawscreen();
            EndPaint(hwnd, &ps);
        break;
        case WM_CLOSE:
            cleanexit(EXIT_SUCCESS);
        break;
        case WM_DESTROY:
            PostQuitMessage(0);
        break;
        case WM_MOVE:
            if (fullscreen)
            {   SetWindowPos
                (   MainWindowPtr,
                    HWND_TOP,
                    0, 0,
                    winwidth, winheight,
                    SWP_NOCOPYBITS
                ); // move it back!
            } else
            {   winleftx = (int) LOWORD(lParam);
                wintopy  = (int) HIWORD(lParam);
            }
        break;
        case WM_COMMAND:
            switch(LOWORD(wParam))
            {   case ID_FILE_EXIT:
                    cleanexit(EXIT_SUCCESS);
                acase ID_FILE_RESET:
                    project_reset();
                acase ID_FILE_RESETTOMONITOR:
                    iar = 0;
                acase ID_FILE_OPEN:
                    project_open();
                acase ID_FILE_SAVESNP:
                    if (machine == ARCADIA)
                    {   DISCARD project_save(KIND_EAS);
                    } elif (machine == INTERTON)
                    {   DISCARD project_save(KIND_INS);
                    } else
                    {   // assert(machine == ELEKTOR);
                        DISCARD project_save(KIND_TVS);
                    }
                acase ID_FILE_SAVEROM:
                    if (machine == ELEKTOR)
                    {   DISCARD project_save(KIND_PGM);
                    } else
                    {   // assert(machine == ARCADIA || machine == INTERTON);
                        DISCARD project_save(KIND_BIN);
                    }
                acase ID_FILE_SAVETVC:
                    // assert(machine == ELEKTOR);
                    DISCARD project_save(KIND_TVC);
                acase ID_OPTIONS_GRAPHICS_1XSIZE:
                    resize(1);
                acase ID_OPTIONS_GRAPHICS_2XSIZE:
                    resize(2);
                acase ID_OPTIONS_GRAPHICS_3XSIZE:
                    resize(3);
                acase ID_OPTIONS_SPEED_REGION: // ie. the region toolbar button
                    if (region == REGION_NTSC)
                    {   region = REGION_PAL;
                    } else
                    {   // assert(region == REGION_PAL);
                        region = REGION_NTSC;
                    }
                    docommand(MENUITEM_REGION);
                acase ID_OPTIONS_SPEED_NTSC:
                    region = REGION_NTSC;
                    docommand(MENUITEM_REGION);
                acase ID_OPTIONS_SPEED_PAL:
                    region = REGION_PAL;
                    docommand(MENUITEM_REGION);
                acase ID_OPTIONS_SPEED_LIMITREFRESH:
                    if (GetMenuState(MenuPtr, ID_OPTIONS_SPEED_LIMITREFRESH, MF_BYCOMMAND) & MF_CHECKED)
                    {   // it was checked, so now we uncheck it
                        limitrefresh = FALSE;
                    } else
                    {   // it was unchecked, so now we check it
                        limitrefresh = TRUE;
                    }
                    updatemenu(MENUITEM_LIMITREFRESH);
                acase ID_OPTIONS_GRAPHICS_FULLSCREEN:
                    if (GetMenuState(MenuPtr, ID_OPTIONS_GRAPHICS_FULLSCREEN, MF_BYCOMMAND) & MF_CHECKED)
                    {   // it was checked, so now we uncheck it
                        fullscreen = FALSE;
                    } else
                    {   // it was unchecked, so now we check it
                        fullscreen = TRUE;
                    }
                    updatemenu(MENUITEM_FULLSCREEN);
                    closewindow();
                    openwindow(TRUE);
                    redrawscreen();
                acase ID_OPTIONS_GRAPHICS_NARROW:
                    if (GetMenuState(MenuPtr, ID_OPTIONS_GRAPHICS_NARROW, MF_BYCOMMAND) & MF_CHECKED)
                    {   // it was checked, so now we uncheck it
                        wide = realwide = 2;
                    } else
                    {   // it was unchecked, so now we check it
                        wide = realwide = 1;
                    }
                    updatemenu(MENUITEM_NARROW);
                    resize(size);
                acase ID_OPTIONS_GRAPHICS_STRETCH:
                    if (GetMenuState(MenuPtr, ID_OPTIONS_GRAPHICS_STRETCH, MF_BYCOMMAND) & MF_CHECKED)
                    {   // it was checked, so now we uncheck it
                        stretch = FALSE;
                    } else
                    {   // it was unchecked, so now we check it
                        stretch = TRUE;
                    }
                    updatemenu(MENUITEM_STRETCH);
                    redrawscreen();
                acase ID_OPTIONS_GRAPHICS_FLAGLINE:
                    if (GetMenuState(MenuPtr, ID_OPTIONS_GRAPHICS_FLAGLINE, MF_BYCOMMAND) & MF_CHECKED)
                    {   // it was checked, so now we uncheck it
                        flagline = FALSE;
                    } else
                    {   // it was unchecked, so now we check it
                        flagline = TRUE;
                    }
                    updatesmlgad(GADPOS_FLAGLINE, flagline, TRUE);
                    updatemenu(MENUITEM_FLAGLINE);
                    if (emulating && paused)
                    {   redrawscreen();
                    }
                acase ID_OPTIONS_GRAPHICS_VLOCK:
                    if (GetMenuState(MenuPtr, ID_OPTIONS_GRAPHICS_VLOCK, MF_BYCOMMAND) & MF_CHECKED)
                    {   // it was checked, so now we uncheck it
                        vlock = FALSE;
                    } else
                    {   // it was unchecked, so now we check it
                        vlock = TRUE;
                    }
                    updatesmlgad(GADPOS_VLOCK, vlock, TRUE);
                    updatemenu(MENUITEM_VLOCK);
                    if (emulating && paused)
                    {   redrawscreen();
                    }
                acase ID_OPTIONS_CONTROLLERS_ANALOG:
                    if (GetMenuState(MenuPtr, ID_OPTIONS_CONTROLLERS_ANALOG, MF_BYCOMMAND) & MF_CHECKED)
                    {   // it was checked, so now we uncheck it
                        analog = FALSE;
                    } else
                    {   // it was unchecked, so now we check it
                        analog = TRUE;
                    }
                    updatesmlgad(GADPOS_ANALOG, analog, TRUE);
                    updatemenu(MENUITEM_ANALOG);
                acase ID_OPTIONS_CONTROLLERS_AUTOFIRE:
                    if (GetMenuState(MenuPtr, ID_OPTIONS_CONTROLLERS_AUTOFIRE, MF_BYCOMMAND) & MF_CHECKED)
                    {   // it was checked, so now we uncheck it
                        autofire = FALSE;
                    } else
                    {   // it was unchecked, so now we check it
                        autofire = TRUE;
                    }
                    updatesmlgad(GADPOS_AUTOFIRE, autofire, TRUE);
                    updatemenu(MENUITEM_AUTOFIRE);
                acase ID_OPTIONS_CONTROLLERS_SWAPPED:
                    if (GetMenuState(MenuPtr, ID_OPTIONS_CONTROLLERS_SWAPPED, MF_BYCOMMAND) & MF_CHECKED)
                    {   // it is checked, so now we uncheck it
                        swapped = FALSE;
                    } else
                    {   // it is unchecked, so now we check it
                        swapped = TRUE;
                    }
                    updatesmlgad(GADPOS_SWAPPED, swapped, TRUE);
                    updatemenu(MENUITEM_SWAPPED);
                acase ID_OPTIONS_SPEED_PAUSED:
                case ID_DEBUG_BREAKCONTINUE:
                    if (GetMenuState(MenuPtr, ID_OPTIONS_SPEED_PAUSED, MF_BYCOMMAND) & MF_CHECKED)
                    {   // it was checked, so now we uncheck it
                        unpause();
                    } else
                    {   // it was unchecked, so now we check it
                        pause();
                    }
                acase ID_OPTIONS_SPEED_WARP:
                    if (GetMenuState(MenuPtr, ID_OPTIONS_SPEED_WARP, MF_BYCOMMAND) & MF_CHECKED)
                    {   // it was checked, so now we uncheck it
                        warp = FALSE;
                    } else
                    {   // it was unchecked, so now we check it
                        warp = TRUE;
                    }
                    updatesmlgad(GADPOS_WARP, warp, TRUE);
                    updatemenu(MENUITEM_WARP);
                acase ID_OPTIONS_SPRITES_COLLISIONS:
                    if (GetMenuState(MenuPtr, ID_OPTIONS_SPRITES_COLLISIONS, MF_BYCOMMAND) & MF_CHECKED)
                    {   // it was checked, so now we uncheck it
                        collisions = FALSE;
                    } else
                    {   // it was unchecked, so now we check it
                        collisions = TRUE;
                    }
                    updatesmlgad(GADPOS_COLLISIONS, collisions, TRUE);
                    updatemenu(MENUITEM_COLLISIONS);
                acase ID_OPTIONS_SPRITES_DEMULTIPLEX:
                    if (GetMenuState(MenuPtr, ID_OPTIONS_SPRITES_DEMULTIPLEX, MF_BYCOMMAND) & MF_CHECKED)
                    {   // it was checked, so now we uncheck it
                        demultiplex = FALSE;
                    } else
                    {   // it was unchecked, so now we check it
                        demultiplex = TRUE;
                    }
                    docommand(MENUITEM_DEMULTIPLEX);
                acase ID_MACHINE_ARCADIA:
                    docommand(COMMAND_ARCADIA);
                acase ID_MACHINE_INTERTON:
                    docommand(COMMAND_INTERTON);
                acase ID_MACHINE_ELEKTOR:
                    docommand(COMMAND_ELEKTOR);
                acase ID_MACHINE_USEHACKS:
                    if (GetMenuState(MenuPtr, ID_MACHINE_USEHACKS, MF_BYCOMMAND) & MF_CHECKED)
                    {   // it was checked, so now we uncheck it
                        usehacks = FALSE;
                    } else
                    {   // it was unchecked, so now we check it
                        usehacks = TRUE;
                    }
                    updatemenu(MENUITEM_USEHACKS);
				acase ID_OPTIONS_AUTOSAVE:
                    if (GetMenuState(MenuPtr, ID_OPTIONS_AUTOSAVE, MF_BYCOMMAND) & MF_CHECKED)
                    {   // it was checked, so now we uncheck it
                        autosave = FALSE;
                    } else
                    {   // it was unchecked, so now we check it
                        autosave = TRUE;
                    }
                    updatemenu(MENUITEM_AUTOSAVE);
                acase ID_SENSEGAME_VERBOSE:
                    sensegame = SENSEGAME_VERBOSE;
					updatemenu(MENUITEM_SENSEGAME);
					updatemenu(MENUITEM_USEHACKS);
                acase ID_SENSEGAME_QUIET:
                    sensegame = SENSEGAME_QUIET;
					updatemenu(MENUITEM_SENSEGAME);
					updatemenu(MENUITEM_USEHACKS);
                acase ID_SENSEGAME_NO:
                    sensegame = SENSEGAME_NO;
					updatemenu(MENUITEM_SENSEGAME);
					updatemenu(MENUITEM_USEHACKS);
                acase ID_OPTIONS_SOUND:
                    if (GetMenuState(MenuPtr, ID_OPTIONS_SOUND, MF_BYCOMMAND) & MF_CHECKED)
                    {   // it was checked, so now we uncheck it
                        sound = FALSE;
                    } else
                    {   // it was unchecked, so now we check it
                        sound = TRUE;
                    }
                    docommand(MENUITEM_SOUND);
                acase ID_DEBUG_WATCHREADS:
                    if (GetMenuState(MenuPtr, ID_DEBUG_WATCHREADS, MF_BYCOMMAND) & MF_CHECKED)
                    {   // it was checked, so now we uncheck it
                        watchreads = FALSE;
                    } else
                    {   // it was unchecked, so now we check it
                        watchreads = TRUE;
                    }
                    updatemenu(MENUITEM_WATCHREADS);
                acase ID_VIEW_MENU:
                    if (GetMenuState(MenuPtr, ID_VIEW_MENU, MF_BYCOMMAND) & MF_CHECKED)
                    {   // it was checked, so now we uncheck it
                        showmenubar = FALSE;
                    } else
                    {   // it was unchecked, so now we check it
                        showmenubar = TRUE;
                    }
                    // no point doing updatemenu(MENUITEM_MENUBAR);
                    closewindow();
                    if (!fullscreen)
					{	winleftx -= 3;
                    }
					openwindow(FALSE);
                    redrawscreen();
                acase ID_VIEW_POINTER:
                    if (GetMenuState(MenuPtr, ID_VIEW_POINTER, MF_BYCOMMAND) & MF_CHECKED)
                    {   // it was checked, so now we uncheck it
                        showpointer = FALSE;
                    } else
                    {   // it was unchecked, so now we check it
                        showpointer = TRUE;
                    }
                    docommand(MENUITEM_POINTER);
                acase ID_VIEW_TITLE:
                    if (GetMenuState(MenuPtr, ID_VIEW_TITLE, MF_BYCOMMAND) & MF_CHECKED)
                    {   // it was checked, so now we uncheck it
                        showtitlebar = FALSE;
                    } else
                    {   // it was unchecked, so now we check it
                        showtitlebar = TRUE;
                    }
                    docommand(MENUITEM_TITLEBAR);
                acase ID_VIEW_TOOL:
                    if (GetMenuState(MenuPtr, ID_VIEW_TOOL, MF_BYCOMMAND) & MF_CHECKED)
                    {   // it was checked, so now we uncheck it
                        showtoolbar = FALSE;
                    } else
                    {   // it was unchecked, so now we check it
                        showtoolbar = TRUE;
                    }
                    docommand(MENUITEM_TOOLBAR);
                acase ID_VIEW_MONITOR:
                    ghost(MENUITEM_MONITOR);
                    if (machine == ARCADIA)
                    {   MonitorWindowPtr = CreateDialog
                        (   InstancePtr,                   // handle to application instance
                            MAKEINTRESOURCE(IDD_AMONITOR), // identifies dialog box template name
                            MainWindowPtr,
                            MonitorDlgProc
                        );
                    } elif (machine == INTERTON)
                    {   MonitorWindowPtr = CreateDialog
                        (   InstancePtr,                   // handle to application instance
                            MAKEINTRESOURCE(IDD_IMONITOR), // identifies dialog box template name
                            MainWindowPtr,
                            MonitorDlgProc
                        );
                    } else
                    {   // assert(machine == ELEKTOR);
                        MonitorWindowPtr = CreateDialog
                        (   InstancePtr,                   // handle to application instance
                            MAKEINTRESOURCE(IDD_EMONITOR), // identifies dialog box template name
                            MainWindowPtr,
                            MonitorDlgProc
                        );
                    }
                    monitortype = machine;
                    initmonitor();
                acase ID_VIEW_PSGS:
                    // assert(machine == ELEKTOR);
					view_psgs();
                acase ID_VIEW_ALLMEMORY:
                    view_allmemory();
                acase ID_VIEW_CRAM:
                    view_cram();
                acase ID_VIEW_MRAM:
                    view_mram();
                acase ID_VIEW_UPPERSCREEN:
                    view_upperscreen();
                acase ID_VIEW_LOWERSCREEN:
                    view_lowerscreen();
                acase ID_VIEW_UDCS:
                    view_udcs();
                acase ID_VIEW_XVI:
                    view_xvi();
                acase ID_VIEW_CPU:
                    view_cpu();
                acase ID_MACRO_TOGGLERECORDING:
                    if (recmode == RECMODE_RECORD)
                    {   macro_stop();
                    } elif (recmode == RECMODE_PLAY)
                    {   // assert(0);
                    } else
                    {   // assert(recmode == RECMODE_NORMAL);
                        macro_startrecording();
                    }
                acase ID_MACRO_TOGGLEPLAYING:
                    if (recmode == RECMODE_RECORD)
                    {   // assert(0);
                    } elif (recmode == RECMODE_PLAY)
                    {   macro_stop();
                    } else
                    {   // assert(recmode == RECMODE_NORMAL);
                        // assert(0);
                    }
                acase ID_MACRO_STARTRECORDING:
                    macro_startrecording();
				acase ID_MACRO_RESTARTPLAYBACK:
					macro_restartplayback();
                acase ID_MACRO_STOP:
                    macro_stop();
                acase ID_MACRO_LOOP:
                    if (GetMenuState(MenuPtr, ID_MACRO_LOOP, MF_BYCOMMAND) & MF_CHECKED)
                    {   // it was checked, so now we uncheck it
                        loop = FALSE;
                    } else
                    {   // it was unchecked, so now we check it
                        loop = TRUE;
                    }
                    docommand(MENUITEM_LOOP);
                acase ID_HELP_ABOUT:
                    if (sound) sound_off();
                    DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_ABOUT), MainWindowPtr, HelpDlgProc);
                    if (sound) sound_on();
                acase ID_VIEW_CONTROLS:
                    ghost(MENUITEM_CONTROLS);
                    for (i = 0; i < KEYS; i++)
					{	oldkeys[i] = 0;
					}
					if (machine == INTERTON)
					{	ControlsWindowPtr = CreateDialog
						(   InstancePtr,                    // handle to application instance
						    MAKEINTRESOURCE(IDD_ICONTROLS), // identifies dialog box template name
						    MainWindowPtr,
						    ControlsDlgProc
						);
					} else
					{	// assert(machine == ARCADIA || machine == ELEKTOR);
						ControlsWindowPtr = CreateDialog
						(   InstancePtr,                    // handle to application instance
						    MAKEINTRESOURCE(IDD_ACONTROLS), // identifies dialog box template name
						    MainWindowPtr,
						    ControlsDlgProc
						);
					}
				    SetActiveWindow(MainWindowPtr);
                acase ID_DEBUG_TRACECPU:
                    if (GetMenuState(MenuPtr, ID_DEBUG_TRACECPU, MF_BYCOMMAND) & MF_CHECKED)
                    {   // it was checked, so now we uncheck it
                        trace = FALSE;
                    } else
                    {   // it was unchecked, so now we check it
                        trace = TRUE;
                    }
                    docommand(MENUITEM_TRACECPU);
                acase ID_DEBUG_LOGINSTRUCTIONS:
                    if (GetMenuState(MenuPtr, ID_DEBUG_LOGINSTRUCTIONS, MF_BYCOMMAND) & MF_CHECKED)
                    {   // it was checked, so now we uncheck it
                        loginstructions = FALSE;
                    } else
                    {   // it was unchecked, so now we check it
                        loginstructions = TRUE;
                    }
                    docommand(MENUITEM_LOGINSTRUCTIONS);
                acase ID_DEBUG_LOGREADS:
                    if (GetMenuState(MenuPtr, ID_DEBUG_LOGREADS, MF_BYCOMMAND) & MF_CHECKED)
                    {   // it was checked, so now we uncheck it
                        logreads = FALSE;
                    } else
                    {   // it was unchecked, so now we check it
                        logreads = TRUE;
                    }
                    updatemenu(MENUITEM_LOGREADS);
                acase ID_DEBUG_LOGWRITES:
                    if (GetMenuState(MenuPtr, ID_DEBUG_LOGWRITES, MF_BYCOMMAND) & MF_CHECKED)
                    {   // it was checked, so now we uncheck it
                        logwrites = FALSE;
                    } else
                    {   // it was unchecked, so now we check it
                        logwrites = TRUE;
                    }
                    updatemenu(MENUITEM_LOGWRITES);
                acase ID_DEBUG_SETBP:
                    debug_set(KIND_BP);
                acase ID_DEBUG_CLEARBP:
                    debug_clearbp();
                acase ID_DEBUG_SETWP:
                    debug_set(KIND_WP);
                acase ID_DEBUG_CLEARWP:
                    debug_clearwp();
                acase ID_DEBUG_STEP:
                    docommand(MENUITEM_STEP);
                acase ID_DEBUG_RUNTORASTLINE:
                    runtorastline = TRUE;
                    unpause();
                acase ID_DEBUG_RUNTORASTN:
                    debug_setrastn();
                    unpause();
                acase ID_DEBUG_RUNTODMA:
                    runtodma = TRUE;
                    unpause();
                acase ID_DEBUG_RUNTOFRAME:
                    runtoframe = TRUE;
                    unpause();
                acase ID_DEBUG_CHANGE:
                    debug_change();
                adefault:
                break;
            }
        acase WM_NOTIFY:
			if ((((LPNMHDR) lParam)->code) == TTN_NEEDTEXT)
			{	lpttt = (LPTOOLTIPTEXT) lParam; // button info
				lpttt->hinst = InstancePtr; // used in our main dialog

				switch(lpttt->hdr.idFrom) // Check which button we hover on
				{
				case ID_FILE_RESET:
					lpttt->lpszText = "Reset to game";
				acase ID_FILE_OPEN:
					lpttt->lpszText = "Open";
				acase ID_FILE_SAVESNP:
					lpttt->lpszText = "Save snapshot";
				acase ID_OPTIONS_GRAPHICS_FLAGLINE:
					lpttt->lpszText = "Flag line emulation?";
				acase ID_OPTIONS_GRAPHICS_VLOCK:
					lpttt->lpszText = "VSCROLL override?";
				acase ID_OPTIONS_CONTROLLERS_ANALOG:
					lpttt->lpszText = "Analog paddles?";
				acase ID_OPTIONS_CONTROLLERS_AUTOFIRE:
					lpttt->lpszText = "Autofire?";
				acase ID_OPTIONS_CONTROLLERS_SWAPPED:
					lpttt->lpszText = "Controllers swapped?";
				acase ID_OPTIONS_SPEED_PAUSED:
					lpttt->lpszText = "Paused?";
				acase ID_OPTIONS_SPEED_WARP:
					lpttt->lpszText = "Warp speed?";
				acase ID_OPTIONS_SPEED_REGION:
					lpttt->lpszText = "PAL/NTSC toggle";
				acase ID_OPTIONS_SPRITES_COLLISIONS:
					lpttt->lpszText = "Collisions?";
				acase ID_OPTIONS_SPRITES_DEMULTIPLEX:
					lpttt->lpszText = "Demultiplex sprites?";
				acase ID_OPTIONS_SOUND:
					lpttt->lpszText = "Sound?";
				acase ID_MACRO_TOGGLEPLAYING:
					lpttt->lpszText = "Play/stop";
				acase ID_MACRO_TOGGLERECORDING:
					lpttt->lpszText = "Record/stop";
				adefault:
				break;
			}	}
		adefault:
            return DefWindowProc(hwnd, msg, wParam, lParam);
    }
    return 0;
}

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{   WNDCLASSEX wc;
    FILE*      LocalHandle /* = NULL */ ;
    SWORD      x, y;
    int        argc,
               i,
               headerbytes,
               length,
               number;
    char**     argv;
    ULONG      thesize;
    FLAG       ok;

#ifdef MODE_CPS
    ULONG      oldelapsed = 0, newelapsed;
#endif

    /* Start of program. */

    InitCommonControls();

    argc = __argc;
    argv = __argv;

    for (x = 0; x < BOXWIDTH; x++)
    {   for (y = 0; y < BOXHEIGHT; y++)
        {   screen[x][y] = 8;
    }   }

    engine_setup();

    DisplayWidth  = GetSystemMetrics(SM_CXSCREEN);
    DisplayHeight = GetSystemMetrics(SM_CYSCREEN);

    DISCARD GetCurrentDirectory(MAX_PATH, ProgDir);
    filepart[0]    =
    thefilename[0] = 0;
    strcpy(pathpart, ".\\Games\\");

    ok = FALSE;
    thesize = getsize("WA.CFG");
    if (thesize <= CONFIGLENGTH + MAX_PATH)
    {   if ((LocalHandle = fopen("WA.CFG", "rb")))
        {   if (fread(ConfigBuffer, 27, 1, LocalHandle) == 1)
            {   ok = TRUE;

                // graphics
                size            = (UBYTE) ConfigBuffer[0];
                wide            = (UBYTE) ConfigBuffer[1];
                vlock           = (ULONG) ConfigBuffer[2];
                analog          = (ULONG) ConfigBuffer[3];
                autofire        = (ULONG) ConfigBuffer[4];
                swapped         = (ULONG) ConfigBuffer[5];
                paused          = (ULONG) ConfigBuffer[6];
                warp            = (ULONG) ConfigBuffer[7];
                collisions      = (ULONG) ConfigBuffer[8];
                sound           = (ULONG) ConfigBuffer[9];
                demultiplex     = (ULONG) ConfigBuffer[10];
                autosave        = (FLAG)  ConfigBuffer[11];
                fullscreen      = (FLAG)  ConfigBuffer[12];
                showmenubar     = (FLAG)  ConfigBuffer[13];
                showtitlebar    = (FLAG)  ConfigBuffer[14];
                showtoolbar     = (FLAG)  ConfigBuffer[15];
                flagline        = (FLAG)  ConfigBuffer[16];
                showpointer     = (FLAG)  ConfigBuffer[17];
                loop            = (FLAG)  ConfigBuffer[18];
                logreads        = (FLAG)  ConfigBuffer[19];
                logwrites       = (FLAG)  ConfigBuffer[20];
                // version is ConfigBuffer[21]
                limitrefresh    = (FLAG)  ConfigBuffer[22];
                machine         = (UBYTE) ConfigBuffer[23];
                loginstructions = (UBYTE) ConfigBuffer[24];
                watchreads      = (UBYTE) ConfigBuffer[25];
                sensegame       = (UBYTE) ConfigBuffer[26];

#define CONFIGVERSION (ConfigBuffer[21])

/* Supported versions are:
4.27:      V7
4.3+:      V8 usehacks[27];
*/

                if (CONFIGVERSION >= 8)
                {   headerbytes = 28;
                    if (fread(&ConfigBuffer[27], 1, 1, LocalHandle) == 1)
                    {   usehacks = (UBYTE) ConfigBuffer[27];
                }   }
                else
                {   headerbytes = 27;
                }
                if (thesize > CONFIGLENGTH)
                {   DISCARD fread(pathpart, thesize - headerbytes, 1, LocalHandle);
            }   }
            DISCARD fclose(LocalHandle);
            // LocalHandle = NULL;
    }   }
    if (!ok)
    {   calcsize(TRUE);
        size = realsize;
    }

    if (argc >= 2)
    {   for (i = 1; i < argc; i++)
        {   if (!strcmp(argv[i], "?"))
            {   printusage(argv[0]);
            } elif (!strnicmp(argv[i], "ANALOG", 6))
            {   if (!stricmp(&argv[i][6], "=ON"))
                {   analog = TRUE;
                } elif (!stricmp(&argv[i][6], "=OFF"))
                {   analog = FALSE;
                } else
                {   printusage(argv[0]);
            }   }
            elif (!strnicmp(argv[i], "AUTOFIRE", 8))
            {   if (!stricmp(&argv[i][8], "=ON"))
                {   autofire = TRUE;
                } elif (!stricmp(&argv[i][8], "=OFF"))
                {   autofire = FALSE;
                } else
                {   printusage(argv[0]);
            }   }
            elif (!strnicmp(argv[i], "AUTOSAVE", 8))
            {   if (!stricmp(&argv[i][8], "=ON"))
                {   autosave = TRUE;
                } elif (!stricmp(&argv[i][8], "=OFF"))
                {   autosave = FALSE;
                } else
                {   printusage(argv[0]);
            }   }
            elif (!strnicmp(argv[i], "COLLISIONS", 10))
            {   if (!stricmp(&argv[i][10], "=ON"))
                {   collisions = TRUE;
                } elif (!stricmp(&argv[i][10], "=OFF"))
                {   collisions = FALSE;
                } else
                {   printusage(argv[0]);
            }   }
            elif (!strnicmp(argv[i], "DEMULTIPLEX", 11))
            {   if (!stricmp(&argv[i][11], "=ON"))
                {   demultiplex = TRUE;
                } elif (!stricmp(&argv[i][11], "=OFF"))
                {   demultiplex = FALSE;
                } else
                {   printusage(argv[0]);
            }   }
            elif (!strnicmp(argv[i], "FLAGLINE", 8))
            {   if (!stricmp(&argv[i][8], "=ON"))
                {   flagline = TRUE;
                } elif (!stricmp(&argv[i][8], "=OFF"))
                {   flagline = FALSE;
                } else
                {   printusage(argv[0]);
            }   }
            elif (!strnicmp(argv[i], "FULLSCREEN", 10))
            {   if (!stricmp(&argv[i][10], "=ON"))
                {   fullscreen = TRUE;
                } elif (!stricmp(&argv[i][10], "=OFF"))
                {   fullscreen = FALSE;
                } else
                {   printusage(argv[0]);
            }   }
            elif (!strnicmp(argv[i], "LIMITREFRESH", 12))
            {   if (!stricmp(&argv[i][12], "=ON"))
                {   limitrefresh = TRUE;
                } elif (!stricmp(&argv[i][12], "=OFF"))
                {   limitrefresh = FALSE;
                } else
                {   printusage(argv[0]);
            }   }
            elif (!strnicmp(argv[i], "MACHINE", 7))
            {   if (!stricmp(&argv[i][7], "=ARCADIA"))
                {   machine = ARCADIA;
                } elif (!stricmp(&argv[i][7], "=INTERTON"))
                {   machine = INTERTON;
                } elif (!stricmp(&argv[i][7], "=ELEKTOR"))
                {   machine = ELEKTOR;
                } else
                {   printusage(argv[0]);
            }   }
            elif (!strnicmp(argv[i], "MENUBAR", 7))
            {   if (!stricmp(&argv[i][7], "=ON"))
                {   showmenubar = TRUE;
                } elif (!stricmp(&argv[i][7], "=OFF"))
                {   showmenubar = FALSE;
                } else
                {   printusage(argv[0]);
            }   }
            elif (!strnicmp(argv[i], "NARROW", 6))
            {   if (!stricmp(&argv[i][6], "=ON"))
                {   wide = 1;
                } elif (!stricmp(&argv[i][6], "=OFF"))
                {   wide = 2;
                } else
                {   printusage(argv[0]);
            }   }
            elif (!strnicmp(argv[i], "PAUSED", 6))
            {   if (!stricmp(&argv[i][6], "=ON"))
                {   paused = TRUE;
                } elif (!stricmp(&argv[i][6], "=OFF"))
                {   paused = FALSE;
                } else
                {   printusage(argv[0]);
            }   }
            elif (!strnicmp(argv[i], "SIZE", 4))
            {   if (!strcmp(&argv[i][4], "=1"))
                {   size = 1;
                } elif (!strcmp(&argv[i][4], "=2"))
                {   size = 2;
                } elif (!strcmp(&argv[i][4], "=3"))
                {   size = 3;
                } else
                {   printusage(argv[0]);
            }   }
            elif (!strnicmp(argv[i], "SOUND", 5))
            {   if (!stricmp(&argv[i][5], "=ON"))
                {   sound = TRUE;
                } elif (!stricmp(&argv[i][5], "=OFF"))
                {   sound = FALSE;
                } else
                {   printusage(argv[0]);
            }   }
            elif (!strnicmp(argv[i], "STRETCH", 7))
            {   if (!stricmp(&argv[i][7], "=ON"))
                {   stretch = TRUE;
                } elif (!stricmp(&argv[i][7], "=OFF"))
                {   stretch = FALSE;
                } else
                {   printusage(argv[0]);
            }   }
            elif (!strnicmp(argv[i], "SWAPPED", 7))
            {   if (!stricmp(&argv[i][7], "=ON"))
                {   swapped = TRUE;
                } elif (!stricmp(&argv[i][7], "=OFF"))
                {   swapped = FALSE;
                } else
                {   printusage(argv[0]);
            }   }
            elif (!strnicmp(argv[i], "TITLEBAR", 8))
            {   if (!stricmp(&argv[i][8], "=ON"))
                {   showtitlebar = TRUE;
                } elif (!stricmp(&argv[i][8], "=OFF"))
                {   showtitlebar = FALSE;
                } else
                {   printusage(argv[0]);
            }   }
            elif (!strnicmp(argv[i], "TOOLBAR", 7))
            {   if (!stricmp(&argv[i][7], "=ON"))
                {   showtoolbar = TRUE;
                } elif (!stricmp(&argv[i][7], "=OFF"))
                {   showtoolbar = FALSE;
                } else
                {   printusage(argv[0]);
            }   }
            elif (!strnicmp(argv[i], "VLOCK", 5))
            {   if (!stricmp(&argv[i][5], "=ON"))
                {   vlock = TRUE;
                } elif (!stricmp(&argv[i][5], "=OFF"))
                {   vlock = FALSE;
                } else
                {   printusage(argv[0]);
            }   }
            elif (!strnicmp(argv[i], "WARP", 4))
            {   if (!stricmp(&argv[i][4], "=ON"))
                {   warp = TRUE;
                } elif (!stricmp(&argv[i][4], "=OFF"))
                {   warp = FALSE;
               } else
                {   printusage(argv[0]);
            }   }
            elif (!strnicmp(argv[i], "LOGINSTRUCTIONS", 15))
            {   if (!stricmp(&argv[i][15], "=ON"))
                {   loginstructions = TRUE;
                } elif (!stricmp(&argv[i][15], "=OFF"))
                {   loginstructions = FALSE;
                } else
                {   printusage(argv[0]);
            }   }
            elif (!strnicmp(argv[i], "LOGREADS", 8))
            {   if (!stricmp(&argv[i][8], "=ON"))
                {   logreads = TRUE;
                } elif (!stricmp(&argv[i][8], "=OFF"))
                {   logreads = FALSE;
                } else
                {   printusage(argv[0]);
            }   }
            elif (!strnicmp(argv[i], "LOGWRITES", 9))
            {   if (!stricmp(&argv[i][9], "=ON"))
                {   logwrites = TRUE;
                } elif (!stricmp(&argv[i][9], "=OFF"))
                {   logwrites = FALSE;
                } else
                {   printusage(argv[0]);
            }   }
            elif
            (    (!strnicmp(argv[i], "BREAKPOINT", 10))
              || (!strnicmp(argv[i], "BP", 2))
            )
            {   if (!strnicmp(argv[i], "BREAKPOINT", 10))
                {   length = 10;
                } else
                {   // assert(!strnicmp(argv[i], "BP", 2));
                    length = 2;
                }

                // sanity checks
                if (argv[i][length] != '=')
                {   printusage(argv[0]);
                }
                if (strlen(&argv[i][length + 1]) > 13)
                {   OPENCONSOLE;
                    DISCARD printf("%s: BREAKPOINT argument must be <= 13 characters!\n", argv[0]);
                    cleanexit(EXIT_FAILURE);
                }

                number = friendly_to_number(&argv[i][length + 1]);
                if (number == OUTOFRANGE)
                {   OPENCONSOLE;
                    DISCARD printf("%s: BREAKPOINT address must be $0000-$7FFF!\n", argv[0]);
                    cleanexit(EXIT_FAILURE);
                } else
                {   bp = number;
                    getfriendly(bp);
                    OPENCONSOLE;
                    DISCARD printf("Set code breakpoint at %s!\n\n", friendly);
                    // no window to be reactivated yet
            }   }
            elif
            (   (!strnicmp(argv[i], "WATCHPOINT", 10))
             || (!strnicmp(argv[i], "WP", 2))
            )
            {   if (!strnicmp(argv[i], "WATCHPOINT", 10))
                {   length = 10;
                } else
                {   // assert(!strnicmp(argv[i], "WP", 2));
                    length = 2;
                }

                // sanity checks
                if (argv[i][length] != '=')
                {   printusage(argv[0]);
                }
                if (strlen(&argv[i][length + 1]) > 13)
                {   OPENCONSOLE;
                    DISCARD printf("%s: WATCHPOINT argument must be <= 13 characters!\n", argv[0]);
                    cleanexit(EXIT_FAILURE);
                }

                number = friendly_to_number(&argv[i][length + 1]);
                if (number == OUTOFRANGE)
                {   OPENCONSOLE;
                    DISCARD printf("%s: WATCHPOINT address must be $0000-$7FFF!\n", argv[0]);
                    cleanexit(EXIT_FAILURE);
                } else
                {   wp = number;
                    getfriendly(wp);
                    OPENCONSOLE;
                    DISCARD printf("Set data watchpoint at %s!\n\n", friendly);
                    // no window to be reactivated yet
            }   }
            elif (!strnicmp(argv[i], "FILE", 4))
            {   if (argv[i][4] != '=')
                {   printusage(argv[0]);
                }
                strcpy(thefilename, (STRPTR) &argv[i][5]);
                // we don't load it yet
            } else
            {   strcpy(thefilename, argv[i]);
                // we don't load it yet
    }   }   }

    menuheight  = GetSystemMetrics(SM_CYMENU);    // normally 19
    titleheight = GetSystemMetrics(SM_CYCAPTION); // normally 19

    OpenChannels(); // we keep the channels open permanently
    if (sound)
    {   sound_on();
    }

    InstancePtr = GetModuleHandle(NULL);

    // AcceleratorPtr = LoadAccelerators(InstancePtr, MAKEINTRESOURCE(IDR_ACCELERATOR)); // automatically freed at exit

    wc.cbSize        = sizeof(WNDCLASSEX);
    wc.style         = 0;
    wc.lpfnWndProc   = WndProc;
    wc.cbClsExtra    = 0;
    wc.cbWndExtra    = 0;
    wc.hInstance     = InstancePtr;
    wc.hIcon         = LoadIcon(InstancePtr, MAKEINTRESOURCE(IDI_ICON));
    wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)(COLOR_GRAYTEXT+1); // was (HBRUSH)(COLOR_WINDOW+1);
    wc.lpszMenuName  = NULL;
    wc.lpszClassName = g_szClassName;
    wc.hIconSm       = LoadIcon(InstancePtr, MAKEINTRESOURCE(IDI_ICON));

    if(!RegisterClassEx(&wc))
    {
        MessageBox(NULL, "Window registration failed!", "WinArcadia: Error",
            MB_ICONEXCLAMATION | MB_OK);
        cleanexit(EXIT_FAILURE);
    }

    openwindow(TRUE); // calls redrawscreen()

    if (machine == ARCADIA)
    {   arcadia();
    } elif (machine == INTERTON)
    {   interton();
    } else
    {   // assert(machine == ELEKTOR);
        elektor();
    }

    if (thefilename[0]) // filename from CLI
    {   if (!engine_load())
        {   // don't beep, the user may have just wanted to set the directory.
            project_reset();
    }   }
    else
    {   strcpy(thefilename, pathpart);
        if (autosave)
        {   if (machine == ARCADIA)
            {   strcat(thefilename, "AUTOSAVE.EAS");
            } elif (machine == INTERTON)
            {   strcat(thefilename, "AUTOSAVE.INS");
            } else
            {   // assert(machine == ELEKTOR);
                strcat(thefilename, "AUTOSAVE.TVS");
            }
            if (!engine_load())
            {   // don't beep
                project_reset();
        }   }
        else
        {   project_reset();
    }   }

    // create bitmap header

#ifdef MODE_SHALLOW
    for (i = 0; i < sizeof(BITMAPINFOHEADER) + (10 * 4); i++)
#else
    for (i = 0; i < sizeof(BITMAPINFOHEADER) + (4 * 4); i++)
#endif

    {   bitmapbuffer[i] = 0;
    }
    BitmapHeaderPtr = (BITMAPINFO *)&bitmapbuffer;
    BitmapHeaderPtr->bmiHeader.biSize = sizeof(BITMAPINFOHEADER);
    BitmapHeaderPtr->bmiHeader.biPlanes = 1;
    BitmapHeaderPtr->bmiHeader.biWidth = BOXWIDTH;
    BitmapHeaderPtr->bmiHeader.biHeight = -BOXHEIGHT; // note well

#ifdef MODE_SHALLOW
    BitmapHeaderPtr->bmiHeader.biBitCount = 8;
    BitmapHeaderPtr->bmiHeader.biCompression = BI_RGB;
    BitmapHeaderPtr->bmiHeader.biClrUsed = 9; // maybe 8 would be enough
    BitmapHeaderPtr->bmiHeader.biClrImportant = 9; // maybe 8 would be enough
    for (i = 0; i < 16; i++)
    {   ((unsigned long *)BitmapHeaderPtr->bmiColors)[i] = pens[i];
    }
#else
    BitmapHeaderPtr->bmiHeader.biBitCount = 32;
    BitmapHeaderPtr->bmiHeader.biCompression = BI_BITFIELDS;
    ((unsigned long *)BitmapHeaderPtr->bmiColors)[0] = 0x00FF0000;
    ((unsigned long *)BitmapHeaderPtr->bmiColors)[1] = 0x0000FF00;
    ((unsigned long *)BitmapHeaderPtr->bmiColors)[2] = 0x000000FF;
#endif

    if (sound && !paused) // must not be done until after loading the game of course
    {   sound_on();
    }
    if (!showpointer) ShowCursor(FALSE);

    while (1)
    {   if (emulating && !paused)
        {   if (machine == ARCADIA)
            {   uvi();
            } else
            {   // assert(machine == INTERTON || machine == ELEKTOR);
                pvi();
            }
            updatemonitor();
            checkinput();
            thewait();

            /* This uses a polling technique to determine whether a second has
               passed. Using timer requests would give better multi-tasking
               performance. */

            if (newtime >= oldtime + 1000)
            {   oldtime = newtime;
#ifdef MODE_FPS
                fps = frames - oldframes; // overflow is possible but unlikely and not very harmful
                oldframes = frames;

                if (fps != oldfps)
                {   oldfps = fps;
                    if (fps <= 9999)
                    {   DISCARD stcul_d(fpsstring, fps);
                    } else
                    {   strcpy(fpsstring, "####");
                    }
                    DISCARD SetWindowText(FPSPtr, fpsstring);
                }
#else
                newelapsed = elapsed - oldelapsed;
                oldelapsed = elapsed;
                DISCARD stcul_d(fpsstring, newelapsed);
                DISCARD SetWindowText(FPSPtr, fpsstring);
#endif
        }   }
        else
        {   fps = 0;
            if (oldfps != 0)
            {   oldfps = 0;
                DISCARD SetWindowText(FPSPtr, "0");
            }
            updatemonitor();

            DISCARD WaitMessage(); // multitask with other programs while paused or not emulating
            checkinput();
    }   }

    // control can never reach here
    // "The return value is only really useful if your program is designed to be called by another program and you want to return a specific value."
    return 0;
}

EXPORT int stcl_d(char* out, long lvalue) // number -> decimal string
{   if (lvalue < 0)
    {   out[0] = '-';
        return(stcul_d(out + 1, (unsigned long int) abs((int) lvalue)) + 1);
    }
    return(stcul_d(out, (unsigned long int) lvalue));
}
EXPORT int stcul_d(char* out, unsigned long lvalue) // number -> decimal string
{   ULONG calc,
          i,
          where   = 0;
    FLAG  started = FALSE;

    for (i = ONE_BILLION; i >= 1; i /= 10)
    {   calc = lvalue / i;
        // assert(calc < 10);
        if (calc || started || i == 1)
        {   *(out + where) = (char) ('0' + calc);
            where++;
            started = TRUE;
        }
        lvalue %= i;
    }

    *(out + where) = 0;
    return((int) where);
}
EXPORT int stcl_h(char* out, unsigned long lvalue)
{   ULONG calc,
          i,
          where   = 0;
    FLAG  started = FALSE;

    for (i = 0x10000000; i >= 1; i /= 16)
    {   calc = lvalue / i;
        // assert(calc < 16);
        if (calc || started || i == 1)
        {   if (calc <= 9)
            {   *(out + where) = (char) ('0' + calc);
            } else
            {   *(out + where) = (char) ('A' + calc - 10);
            }
            where++;
            started = TRUE;
        }
        lvalue %= i;
    }

    *(out + where) = 0;
    return((int) where);
}
EXPORT int stcd_l(char* in, SLONG* lvalue) // string -> decimal number
{   *(lvalue) = atol(in);
    return 1; // not really
}
EXPORT int stch_l(char* in, SLONG* lvalue) // string -> hex number
{   *(lvalue) = strtol(in, NULL, 16);
    return 1; // not really
}

BOOL CALLBACK HelpDlgProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{   switch(Message)
    {
        case WM_INITDIALOG:
            return TRUE;
        break;
        case WM_CLOSE:
            clearkybd();
            EndDialog(hwnd, 0);
            return TRUE;
        break;
        case WM_COMMAND:
            if
            (   (LOWORD (wParam) == IDC_LINK1)
             || (LOWORD (wParam) == IDC_AMIGANSOFTWARE)
            )
            {   ShellExecute(0, NULL, "http://amigan.1emu.net/releases/", NULL, NULL, SW_SHOW);
            } elif
			(   (LOWORD (wParam) == IDC_LINK2)
             || (LOWORD (wParam) == IDC_EA2001CENTRAL)
			)
            {   ShellExecute(0, NULL, "http://amigan.classicgaming.gamespy.com/",   NULL, NULL, SW_SHOW);
            } elif (LOWORD (wParam) == ID_OK) // NOT IDOK!
            {   clearkybd();
                EndDialog(hwnd, 0);
            }
            return TRUE;
        break;
        default:
            return FALSE;
    }
    return TRUE;
}

BOOL CALLBACK SetDlgProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{   int number;

    switch(Message)
    {
    case WM_INITDIALOG:
        if (dlgtype == DLGTYPE_BP)
        {   if (bp == OUTOFRANGE)
            {   SetWindowText(GetDlgItem(hwnd, IDC_POINT), "");
            } else
            {   number_to_friendly(bp, friendly, FALSE);
                SetWindowText(GetDlgItem(hwnd, IDC_POINT), friendly);
        }   }
        else
        {   // assert(dlgtype == DLGTYPE_WP);
            if (wp == OUTOFRANGE)
            {   SetWindowText(GetDlgItem(hwnd, IDC_POINT), "");
            } else
            {   number_to_friendly(wp, friendly, FALSE);
                SetWindowText(GetDlgItem(hwnd, IDC_POINT), friendly);
        }   }

        return TRUE;
    break;
    case WM_CLOSE:
        goto DONE;
    break;
    case WM_COMMAND:
        if (LOWORD (wParam) == IDOK)
        {   goto DONE;
        }

        return FALSE;
    break;
    default:
        return FALSE;
    break;
    }

    return TRUE;

DONE:
    GetWindowText(GetDlgItem(hwnd, IDC_POINT), friendly, sizeof(friendly));
    number = friendly_to_number(friendly);
    if (number == OUTOFRANGE)
    {   ; // OPENCONSOLE;
        // printf("Cancelled!\n\n");
        // REACTIVATE;
    } elif (dlgtype == DLGTYPE_BP)
    {   if (bp != number) // just to prevent needless messages
        {   bp = number;
            getfriendly(bp);
            OPENCONSOLE;
            printf("Set code breakpoint to %s!\n\n", friendly);
            REACTIVATE;
    }   }
    else
    {   // assert(dlgtype == DLGTYPE_WP);
        if (wp != number) // just to prevent needless messages
        {   wp = number;
            getfriendly(wp);
            OPENCONSOLE;
            printf("Set data watchpoint to %s!\n\n", friendly);
            REACTIVATE;
    }   }
    clearkybd();
    EndDialog(hwnd, 0);

    return TRUE;
}

BOOL CALLBACK RastNDlgProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{   switch(Message)
    {
    case WM_INITDIALOG:
        stcl_d(globalstring, rastn); // number -> decimal string
        SetWindowText(GetDlgItem(hwnd, IDC_POINT), globalstring);

        return TRUE;
    break;
    case WM_CLOSE:
        goto DONE;
    break;
    case WM_COMMAND:
        if (LOWORD (wParam) == IDOK)
        {   goto DONE;
        }
        if (LOWORD (wParam) == IDCANCEL)
        {   clearkybd();
            EndDialog(hwnd, 0);

            return TRUE;
        }

        return FALSE;
    break;
    default:
        return FALSE;
    break;
    }

    return TRUE;

DONE:
    GetWindowText(GetDlgItem(hwnd, IDC_POINT), globalstring, sizeof(globalstring));
    stcd_l(globalstring, &rastn); // string -> decimal number
    // we should really bounds check this number

    clearkybd();
    EndDialog(hwnd, 0);

    return TRUE;
}

BOOL CALLBACK MonitorDlgProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{   switch(Message)
    {
        case WM_INITDIALOG:
            return TRUE;
        break;
        case WM_CLOSE:
            DestroyWindow(hwnd);
            MonitorWindowPtr = NULL;
            unghost(MENUITEM_MONITOR);
            return TRUE;
        break;
        default:
            return FALSE;
    }
    return TRUE;
}

BOOL CALLBACK ControlsDlgProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{   switch(Message)
    {
        case WM_INITDIALOG:
            if (machine == ELEKTOR)
            {   controlstype = ARCADIA;
            } else
            {   controlstype = machine;
            }
            return TRUE;
        break;
        case WM_CLOSE:
            DestroyWindow(hwnd);
            ControlsWindowPtr = NULL;
            unghost(MENUITEM_CONTROLS);
            return TRUE;
        break;
        default:
            return FALSE;
    }
    return TRUE;
}

MODULE void project_open(void)
{   OPENFILENAME ofn;

    macro_stop();
    sound_off();
    if (!showpointer)
    {   ShowCursor(TRUE);
    }

    split();
    ZeroMemory(&ofn, sizeof(ofn));

    ofn.lStructSize = sizeof(ofn);
    ofn.hwndOwner = MainWindowPtr;
    ofn.lpstrFilter =
    "All Arcadia/Interton/Elektor Files (*.BIN, *.EAS, *.EAR, *.INS, *.INR, *.PGM, *.TVC, *.TVS, *.TVR)\0*.BIN;*.EAS;*.EAR;*.INS;*.INR;*.PGM;*.TVC;*.TVS;*.TVR\0"
    /* first extension listed (.BIN) is the default */
    "All Arcadia Files (*.BIN, *.EAS, *.EAR)\0*.BIN;*.EAS;*.EAR\0"
    "All Interton Files (*.BIN, *.INS, *.INR)\0*.BIN;*.INS;*.INR\0"
    "All Elektor Files (*.PGM, *.TVC, *.TVS, *.TVR)\0*.PGM;*.TVC;*.TVS;*.TVR\0"
    "Arcadia/Interton ROMs (*.BIN)\0*.BIN\0"
    "Emerson Arcadia 2001 Snapshots (*.EAS)\0*.EAS\0"
    "Emerson Arcadia 2001 Recordings (*.EAR)\0*.EAR\0"
    "Interton VC 4000 Snapshots (*.INS)\0*.INS\0"
    "Interton VC 4000 Recordings (*.INR)\0*.INR\0"
    "Elektor TV Games Computer Programs (*.PGM, *.TVC)\0*.PGM;*.TVC\0"
    "Elektor TV Games Computer Snapshots (*.TVS)\0*.TVS\0"
    "Elektor TV Games Computer Recordings (*.TVR)\0*.TVR\0"
    "All Files (*.*)\0*.*\0";
    ofn.lpstrFile = filepart;
    ofn.nMaxFile = MAX_PATH;
    ofn.Flags = OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
    if (machine == ELEKTOR)
    {   ofn.lpstrDefExt = "PGM";
    } else
    {   // assert(machine == ARCADIA || machine == INTERTON);
        ofn.lpstrDefExt = "BIN";
    }
    ofn.lpstrInitialDir = (LPSTR) pathpart;

    clearkybd();

    if (GetOpenFileName(&ofn))
    {   strcpy(thefilename, filepart);
        // what was chosen is now in thefilename

        if (machine == ELEKTOR)
        {   fixextension_load(".PGM");
        } else
        {   // assert(machine == ARCADIA || machine == INTERTON);
            fixextension_load(".BIN");
        }

        DISCARD engine_load();
    }

    if (!showpointer)
    {   ShowCursor(FALSE);
    }
    if (sound)
    {   sound_on();
}   }

EXPORT ULONG getsize(STRPTR filename)
{   HANDLE hFile /* = NULL */ ;
    ULONG  size;

    hFile = CreateFile(filename, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, NULL);
    if (hFile == INVALID_HANDLE_VALUE)
    {   return(0);
    }
    size = GetFileSize(hFile, NULL);
    CloseHandle(hFile);
    // hFile = NULL;

    if (size == (ULONG) -1)
    {   return(0);
    }

    return(size);
}

EXPORT void checkinput(void)
{   MSG   Msg;
    ULONG scancode;

    if (!emulating || paused)
    {   DISCARD WaitMessage(); // to give better multitasking
    }

    while(PeekMessage(&Msg, NULL, 0, 0, PM_REMOVE))
    {   switch(Msg.message)
        {
        case WM_KEYDOWN:
            scancode = (Msg.lParam & 33488896) >> 16;
            handlekybd(scancode);
        acase WM_KEYUP:
            scancode = (Msg.lParam & 33488896) >> 16;
            KeyMatrix[scancode / 8] &= (255 - (1 << (scancode % 8)));
        adefault:
            TranslateMessage(&Msg);
            DispatchMessage(&Msg);
        break;
    }   }

    return; // return Msg.wParam;
}

EXPORT UBYTE KeyDown(UWORD scancode) // scancode must be at least 16 bits wide!
{   if (KeyMatrix[scancode / 8] & (1 << (scancode % 8)))
    {   return(1);
    }
    return(0);
}

MODULE void debug_set(int kind)
{   if (sound) sound_off();
    if (kind == KIND_BP)
    {   dlgtype = DLGTYPE_BP;
        DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_SETBP), MainWindowPtr, SetDlgProc);
    } else
    {   // assert(dlgtype = DLGTYPE_WP);
        dlgtype = DLGTYPE_WP;
        DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_SETWP), MainWindowPtr, SetDlgProc);
    }
    updatemenus();
    if (sound) sound_on();
}
MODULE void debug_setrastn(void)
{   if (sound) sound_off();
    DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_RUNTORASTN), MainWindowPtr, RastNDlgProc);
    if (sound) sound_on();
}

EXPORT void redrawscreen(void)
{   SWORD   centrex, centrey,
            x, y,
            xunit, yunit;
    RECT    localrect;
    POINT   point[4];
    HBRUSH  BrushPtr[3];
    HGDIOBJ LocalOldObject;
    HDC     OnScreenRastPort;

    if (!stretch && fullscreen)
    {   if (showtoolbar)
        {   localrect.top = TOOLBARHEIGHT;
        } else
        {   localrect.top = 0;
        }
        localrect.bottom = winheight;
        localrect.left = 0;
        localrect.right = winwidth;
        /* Note that there is slight flickering caused by this; ideally
        we would only fill the borders with grey, not the whole client area of the window. */
        OnScreenRastPort = GetDC(MainWindowPtr);
        FillRect(OnScreenRastPort, &localrect, GetStockObject(GRAY_BRUSH));
        DISCARD ReleaseDC(MainWindowPtr, OnScreenRastPort);
    }

    if (emulating)
    {   for (x = 0; x < BOXWIDTH; x++)
        {   for (y = 0; y < BOXHEIGHT; y++)
            {   drawpixel(x, y, screen[x][y]);
        }   }

        updatescreen();
    } else
    {   if (machine == ELEKTOR)
        {   return;
        }

        OnScreenRastPort = GetDC(MainWindowPtr);

        if (stretch && fullscreen)
        {   xunit            = (SWORD) (winwidth / 40);
            yunit            = clientheight / 40;
            centrex          = (SWORD) (winwidth / 2);
            centrey          = stretchyoffset + (clientheight / 2);
            localrect.left   = 0;
            localrect.top    = stretchyoffset;
            localrect.right  = winwidth;
            localrect.bottom = winheight;

            FillRect(OnScreenRastPort, &localrect, GetStockObject(BLACK_BRUSH));
        } else
        {   xunit            = rastwidth  / 40;
            yunit            = rastheight / 40;
            centrex          = xoffset + (rastwidth  / 2);
            centrey          = yoffset + (rastheight / 2);
            localrect.left   = xoffset;
            localrect.top    = yoffset;
            localrect.right  = xoffset + rastwidth;
            localrect.bottom = yoffset + rastheight;
        }

        if (machine == ARCADIA)
        {   FillRect(OnScreenRastPort, &localrect, GetStockObject(BLACK_BRUSH));
            point[0].x = centrex - ( 8 * xunit); // top left
            point[0].y = centrey - ( 6 * yunit);
            point[1].x = centrex - ( 4 * xunit); // top right
            point[1].y = centrey - ( 6 * yunit);
            point[2].x = centrex - ( 8 * xunit); // bottom right
            point[2].y = centrey + ( 6 * yunit);
            point[3].x = centrex - (12 * xunit); // bottom left
            point[3].y = centrey + ( 6 * yunit);

            BrushPtr[0] = CreateSolidBrush(RGB(255, 0, 0));
            LocalOldObject = SelectObject(OnScreenRastPort, BrushPtr[0]);
            DISCARD Polygon(OnScreenRastPort, point, 4);

            point[0].x += xunit * 8;
            point[1].x += xunit * 8;
            point[2].x += xunit * 8;
            point[3].x += xunit * 8;
            BrushPtr[1] = CreateSolidBrush(RGB(0, 255, 0));
            DISCARD SelectObject(OnScreenRastPort, BrushPtr[1]);
            DISCARD Polygon(OnScreenRastPort, point, 4);

            point[0].x += xunit * 8;
            point[1].x += xunit * 8;
            point[2].x += xunit * 8;
            point[3].x += xunit * 8;
            BrushPtr[2] = CreateSolidBrush(RGB(0, 0, 255));
            DISCARD SelectObject(OnScreenRastPort, BrushPtr[2]);
            DISCARD Polygon(OnScreenRastPort, point, 4);

            DeleteObject(BrushPtr[1]);
            DeleteObject(BrushPtr[2]);
        } else
        {   // assert(machine == INTERTON);

            FillRect(OnScreenRastPort, &localrect, GetStockObject(BLACK_BRUSH));

            BrushPtr[0] = CreateSolidBrush(RGB(128, 128, 128));

            LocalOldObject = SelectObject(OnScreenRastPort, BrushPtr[0]);
            Ellipse(OnScreenRastPort, centrex - (10 * xunit), centrey - (10 * yunit), centrex + (10 * xunit), centrey + (10 * yunit));
            DISCARD SelectObject(OnScreenRastPort, GetStockObject(BLACK_BRUSH));
            Ellipse(OnScreenRastPort, centrex - ( 9 * xunit), centrey - ( 9 * yunit), centrex + ( 9 * xunit), centrey + ( 9 * yunit));
            DISCARD SelectObject(OnScreenRastPort, BrushPtr[0]);
            Ellipse(OnScreenRastPort, centrex - ( 8 * xunit), centrey - ( 8 * yunit), centrex + ( 8 * xunit), centrey + ( 8 * yunit));
            DISCARD SelectObject(OnScreenRastPort, GetStockObject(BLACK_BRUSH));
            Ellipse(OnScreenRastPort, centrex - ( 7 * xunit), centrey - ( 7 * yunit), centrex + ( 7 * xunit), centrey + ( 7 * yunit));
            DISCARD SelectObject(OnScreenRastPort, BrushPtr[0]);
            Ellipse(OnScreenRastPort, centrex - ( 6 * xunit), centrey - ( 6 * yunit), centrex + ( 6 * xunit), centrey + ( 6 * yunit));
            DISCARD SelectObject(OnScreenRastPort, GetStockObject(BLACK_BRUSH));
            Ellipse(OnScreenRastPort, centrex - ( 5 * xunit), centrey - ( 5 * yunit), centrex + ( 5 * xunit), centrey + ( 5 * yunit));
            DISCARD SelectObject(OnScreenRastPort, BrushPtr[0]);
            Ellipse(OnScreenRastPort, centrex - ( 4 * xunit), centrey - ( 4 * yunit), centrex + ( 4 * xunit), centrey + ( 4 * yunit));
            DISCARD SelectObject(OnScreenRastPort, GetStockObject(BLACK_BRUSH));
            Ellipse(OnScreenRastPort, centrex - ( 3 * xunit), centrey - ( 3 * yunit), centrex + ( 3 * xunit), centrey + ( 3 * yunit));
            DISCARD SelectObject(OnScreenRastPort, BrushPtr[0]);
            Ellipse(OnScreenRastPort, centrex - ( 2 * xunit), centrey - ( 2 * yunit), centrex + ( 2 * xunit), centrey + ( 2 * yunit));
            DISCARD SelectObject(OnScreenRastPort, GetStockObject(BLACK_BRUSH));
            Ellipse(OnScreenRastPort, centrex -       xunit , centrey -       yunit , centrex +       xunit , centrey +       yunit );
        }

        DISCARD SelectObject(OnScreenRastPort, LocalOldObject);
        DeleteObject(BrushPtr[0]);

        DISCARD ReleaseDC(MainWindowPtr, OnScreenRastPort);
}   }

EXPORT void updatescreen(void)
{   HDC OnScreenRastPort;

    OnScreenRastPort = GetDC(MainWindowPtr);
    if (stretch && fullscreen)
    {   DISCARD StretchDIBits
        (   OnScreenRastPort,
            0,              // dest leftx
            stretchyoffset, // dest topy
            winwidth,       // dest width
            clientheight,   // dest height
            0,              // source leftx
            0,              // source topy
            BOXWIDTH,       // source width
            BOXHEIGHT,      // source height
            display,        // pointer to the bits
            BitmapHeaderPtr, // pointer to BITMAPINFO structure
            DIB_RGB_COLORS, // format of data
            SRCCOPY         // blit mode
        );
    } else
    {   DISCARD StretchDIBits
        (   OnScreenRastPort,
            xoffset,        // dest leftx
            yoffset,        // dest topy
            rastwidth,      // dest width
            rastheight,     // dest height
            0,              // source leftx
            0,              // source topy
            BOXWIDTH,       // source width
            BOXHEIGHT,      // source height
            display,        // pointer to the bits
            BitmapHeaderPtr, // pointer to BITMAPINFO structure
            DIB_RGB_COLORS, // format of data
            SRCCOPY         // blit mode
        );
    }
    DISCARD ReleaseDC(MainWindowPtr, OnScreenRastPort);
}

MODULE __inline void thewait(void)
{   PERSIST ULONG howlong = 0; // doesn't matter much what the starting value is, garbage would be fine too

    /* 1/3rd of the time we wait for 16 milliseconds.
       2/3rd of the time we wait for 17 milliseconds */

    newtime = timeGetTime();
    if (warp)
    {   if (limitrefresh && newtime >= waittill)
        {   updatescreen();
            waittill = newtime;

            if (region == REGION_NTSC)
            {   if ((howlong % 3) == 0)
                {   waittill += 16;
                } else
                {   waittill += 17;
                }
                howlong++;
            } else
            {   // assert(region == REGION_PAL);
                waittill += 20;
    }   }   }
    else
    {   // As soon as we have finished waiting, we calculate how much we
        // should wait next time. This way the time consumed in doing the
        // emulation is taken into account.

        // The way it is implemented, it will return immediately on the
        // first frame, but all subsequent frames are timed correctly.

        if (newtime < waittill)
        {   do
            {   newtime = timeGetTime();
            } while (newtime < waittill);
        } else
        {   waittill = newtime;
        }

        if (KeyDown(SCAN_APOSTROPHE))
        {   waittill += 1000;
        } elif (region == REGION_NTSC)
        {   if ((howlong % 3) == 0)
            {   if (KeyDown(SCAN_SEMICOLON))
                {   waittill += 66;
                } else
                {   waittill += 16;
            }   }
            else
            {   if (KeyDown(SCAN_SEMICOLON))
                {   waittill += 67;
                } else
                {   waittill += 17;
            }   }
            howlong++;
        } else
        {   // assert(region == REGION_PAL);
            if (KeyDown(SCAN_SEMICOLON))
            {   waittill += 80;
            } else
            {   waittill += 20;
}   }   }   }

MODULE void drawpixel(SLONG x, SLONG y, UBYTE colour)
{   // assert(x >= 0);
    // assert(x < BOXWIDTH);
    // assert(y >= 0);
    // assert(y < BOXHEIGHT);
    // assert(colour >= 0 && colour <= 15);

    // This version expects Arcadia-format colours!
    screen[x][y] = colour;

#ifdef MODE_SHALLOW
    display[x + (y * EVENBOXWIDTH)] = colour;
#else
    display[x + (y * BOXWIDTH)] = pens[colour];
#endif
}

EXPORT void project_save(int kind)
{   OPENFILENAME ofn;

    if (!emulating)
    {   return;
    }

    macro_stop();
    sound_off();
    if (!showpointer)
    {   ShowCursor(TRUE);
    }

    // these two lines are order-dependent!
    split();
    fixextension_save(kind);

    ZeroMemory(&ofn, sizeof(ofn));

    ofn.lStructSize = sizeof(ofn);
    ofn.hwndOwner = MainWindowPtr;
    if (kind == KIND_EAS)
    {   ofn.lpstrFilter = "Emerson Arcadia 2001 Snapshot (*.EAS)\0*.EAS\0All Files (*.*)\0*.*\0";
        ofn.lpstrDefExt = "EAS";
    } elif (kind == KIND_INS)
    {   ofn.lpstrFilter = "Interton VC 4000 Snapshot (*.INS)\0*.INS\0All Files (*.*)\0*.*\0";
        ofn.lpstrDefExt = "INS";
    } elif (kind == KIND_TVS)
    {   ofn.lpstrFilter = "Elektor TV Games Computer Snapshot (*.TVS)\0*.TVS\0All Files (*.*)\0*.*\0";
        ofn.lpstrDefExt = "TVS";
    } elif (kind == KIND_PGM)
    {   ofn.lpstrFilter = "Elektor TV Games Computer Program (*.PGM)\0*.PGM\0All Files (*.*)\0*.*\0";
        ofn.lpstrDefExt = "PGM";
    } elif (kind == KIND_TVC)
    {   ofn.lpstrFilter = "Elektor TV Games Computer Program (*.TVC)\0*.TVC\0All Files (*.*)\0*.*\0";
        ofn.lpstrDefExt = "TVC";
    } elif (kind == KIND_BIN)
    {   // assert(machine == ARCADIA || machine == INTERTON);
        ofn.lpstrFilter = "Arcadia/Interton ROM (*.BIN)\0*.BIN\0All Files (*.*)\0*.*\0";
        ofn.lpstrDefExt = "BIN";
    } // else assert(0);
    ofn.lpstrFile = filepart;
    ofn.nMaxFile = MAX_PATH;
    ofn.lpstrInitialDir = (LPSTR) pathpart;
    ofn.Flags = OFN_EXPLORER | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;

    clearkybd();
    if(!(GetSaveFileName(&ofn)))
    {   if (!showpointer)
        {   ShowCursor(FALSE);
        }
        if (sound)
        {   sound_on();
    }   }
    else
    {   if (!showpointer)
        {   ShowCursor(FALSE);
        }
        // filepart now contains both path and filename
        strcpy(thefilename, filepart);
        engine_save(kind, TRUE);
}   }

EXPORT void freeall(void)
{   FILE*      LocalHandle /* = NULL */ ;
    signed int where = -1,
               thelength,
               i;

    macro_stop();
    sound_off();

    for (i = 0; i < 14; i++)
    {   PSGClose(i);
    }

    strcpy(pathpart, thefilename);
    where = -1;
    thelength = strlen(pathpart);
    for (i = 0; i < thelength; i++)
    {   if
        (   pathpart[i] == ':'
         || pathpart[i] == '\\'
        )
        {   where = i;
            // don't break, we want the LAST component, not the FIRST
    }   }
    pathpart[where + 1] = 0;
    strcpy(thefilename, pathpart);
    if (machine == ARCADIA)
    {   strcat(thefilename, "AUTOSAVE.EAS");
    } elif (machine == INTERTON)
    {   strcat(thefilename, "AUTOSAVE.INS");
    } else
    {   // assert(machine == ELEKTOR);
        strcat(thefilename, "AUTOSAVE.TVS");
    }
    // filepart will be wrong but we don't use it

    if (ProgDir[0])
    {   DISCARD SetCurrentDirectory(ProgDir);
    }
    if (emulating && autosave && !crippled && game)
    {   if (machine == ARCADIA)
        {   engine_save(KIND_EAS, FALSE);
        } elif (machine == INTERTON)
        {   engine_save(KIND_INS, FALSE);
        } else
        {   // assert(machine == ELEKTOR);
            engine_save(KIND_TVS, FALSE);
    }   }

    if ((LocalHandle = fopen("WA.CFG", "wb")))
    {   ConfigBuffer[0]  = (UBYTE) size;
        ConfigBuffer[1]  = (UBYTE) wide;
        ConfigBuffer[2]  = (UBYTE) vlock;
        ConfigBuffer[3]  = (UBYTE) analog;
        ConfigBuffer[4]  = (UBYTE) autofire;
        ConfigBuffer[5]  = (UBYTE) swapped;
        ConfigBuffer[6]  = (UBYTE) paused;
        ConfigBuffer[7]  = (UBYTE) warp;
        ConfigBuffer[8]  = (UBYTE) collisions;
        ConfigBuffer[9]  = (UBYTE) sound;
        ConfigBuffer[10] = (UBYTE) demultiplex;
        ConfigBuffer[11] = (UBYTE) autosave;
        ConfigBuffer[12] = (UBYTE) fullscreen;
        ConfigBuffer[13] = (UBYTE) showmenubar;
        ConfigBuffer[14] = (UBYTE) showtitlebar;
        ConfigBuffer[15] = (UBYTE) showtoolbar;
        ConfigBuffer[16] = (UBYTE) flagline;
        ConfigBuffer[17] = (UBYTE) showpointer;
        ConfigBuffer[18] = (UBYTE) loop;
        ConfigBuffer[19] = (UBYTE) logreads;
        ConfigBuffer[20] = (UBYTE) logwrites;
        ConfigBuffer[21] = (UBYTE) 8; /* 8 means V4.3+ */
        ConfigBuffer[22] = (UBYTE) limitrefresh;
        ConfigBuffer[23] = (UBYTE) machine;
        ConfigBuffer[24] = (UBYTE) loginstructions;
        ConfigBuffer[25] = (UBYTE) watchreads;
        ConfigBuffer[26] = (UBYTE) sensegame;
        ConfigBuffer[27] = (UBYTE) usehacks;

        DISCARD fwrite(ConfigBuffer, CONFIGLENGTH,         1, LocalHandle);
        DISCARD fwrite(pathpart,     strlen(pathpart) + 1, 1, LocalHandle);
        DISCARD fclose(LocalHandle);
        // LocalHandle = NULL;
}   }

EXPORT void cleanexit(SBYTE rc)
{   if (consoleopen)
    {   printf("Exiting.\n");
    }

    freeall();

    // PostMessage(MainWindowPtr, WM_CLOSE, 0, 0);
    DestroyWindow(MainWindowPtr);
    // MainWindowPtr = NULL;

    exit(rc);
}

EXPORT UBYTE ReadJoystick(UWORD joynum)
{   JOYINFO JoyInfo;
    UBYTE   rc = 0;
    UINT    id;

    // joynum will be '1' if they want the PRIMARY port
    // joynum will be '0' if they want the SECONDARY port
    if (joynum == 1)
    {   id = JOYSTICKID1;
    } else
    {   // assert(joynum == 0);
        id = JOYSTICKID2;
    }

    if (joy[joynum] && joyGetPos(id, &JoyInfo) == JOYERR_NOERROR)
    {   if (JoyInfo.wXpos < 0)
            rc |= JOYLEFT;
        elif (JoyInfo.wXpos > 0)
            rc |= JOYRIGHT;
        if (JoyInfo.wYpos < 0)
            rc |= JOYUP;
        elif (JoyInfo.wYpos > 0)
            rc |= JOYDOWN;
        if (JoyInfo.wButtons)
            rc |= JOYFIRE1;
        return rc;
    } else
    {   return 0;
}   }

EXPORT void sound_off(void)
{   int i;

    for (i = 0; i < 14; i++)
    {   PSGStop(i);
}   }

EXPORT void sound_on(void)
{   /* if (!waveOutGetNumDevs()) // if no sound output devices found
    {   MessageBox(MainWindowPtr, "waveOutGetNumDevs() failed!", "WinArcadia: Error", MB_OK | MB_ICONERROR);
    } */

    // we used to call OpenChannels() here

    if (emulating && !paused)
    {   playsound(TRUE);
}   }

MODULE void calcsize(FLAG autosize)
{   int realsize1,
        realsize2;

    if (fullscreen || autosize)
    {   winwidth  = DisplayWidth;
        winheight = DisplayHeight;

        // "client area" is as considered by the user, not by Windows
        clientheight = DisplayHeight;
        if (showtitlebar)
        {   clientheight -= titleheight;
        }
        if (showmenubar)
        {   clientheight -= menuheight;
        }
        if (showtoolbar)
        {   clientheight -= TOOLBARHEIGHT;
        }
        realwide = 2;
        realsize1 = clientheight / BOXHEIGHT;
        realsize2 = winwidth     / (BOXWIDTH * realwide);
        if (realsize1 < realsize2)
        {   realsize = realsize1;
        } else
        {   realsize = realsize2;
        }
        rastwidth  = BOXWIDTH  * realsize * realwide;
        rastheight = BOXHEIGHT * realsize;
        xoffset = (winwidth     - rastwidth ) / 2;
        yoffset = (clientheight - rastheight) / 2;
        if (showtoolbar)
        {   yoffset += TOOLBARHEIGHT;
            stretchyoffset = TOOLBARHEIGHT;
        } else
        {   stretchyoffset = 0;
    }   }
    else
    {   winwidth  = rastwidth  = (SWORD) BOXWIDTH  * size * wide;
        winheight = rastheight = (SWORD) BOXHEIGHT * size;

        if (showtitlebar)
        {   winheight += titleheight;
        }
        if (showmenubar)
        {   winheight += menuheight;
            if (size == 1 && wide == 1)
            {   winheight += menuheight;
        }   }
        if (showtoolbar)
        {   winheight += TOOLBARHEIGHT;
            yoffset = TOOLBARHEIGHT;
        } else
        {   yoffset = 0;
        }

        realwide = wide;
        realsize = size;
        xoffset = 0;
    }

    if (showtitlebar)
	{   winwidth  += 6;
	    winheight += 6;
}	}

MODULE void resize(int newsize)
{   size = realsize = newsize;
    updatemenu(MENUITEM_SIZE);
    calcsize(FALSE);
    SetWindowPos
    (   MainWindowPtr,
        HWND_TOP,
        (DisplayWidth / 2) - (winwidth / 2),
        (DisplayHeight / 2) - (winheight / 2),
        winwidth, winheight,
        SWP_NOCOPYBITS
    );
    maketoolbar(MainWindowPtr);
    redrawscreen();
}

EXPORT void beep(void)     { ; }
EXPORT void readkybd(void) { ; }

EXPORT void playsound(FLAG force)
{   AUTO    double hertz;
    AUTO    UWORD  psgpitch[14];
    AUTO    UBYTE  psgvolume[14];
    AUTO    int    i; // PERSIST would be faster
    PERSIST UWORD  oldpsgpitch[14]  = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    PERSIST UBYTE  oldpsgvolume[14] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    /* Although Arcadia and Interton/Elektor volumes do not match, this
       is unimportant as playsound(TRUE) is called when changing machines.
       Thus, Arcadia volumes are never compared against Interton/Elektor
       volumes. */

    if (!sound)
    {   return;
    }

    if (machine == ARCADIA)
    {   if ((memory[A_VOLUME]) & 0x08)
        {   psgpitch[6]   = memory[A_PITCH]  & 0x7F;
            psgvolume[6]  = memory[A_VOLUME] & 0x07; // 0..7
        } else
        {   psgpitch[6]   =
            psgvolume[6]  = 0;
        }

        if ((memory[A_VOLUME]) & 0x10)
        {   psgpitch[13]  = memory[A_PITCH]  & 0x7F;
            psgvolume[13] = memory[A_VOLUME] & 0x07; // 0..7
        } else
        {   psgpitch[13]  =
            psgvolume[13] = 0;
    }   }
    else
    {   // assert(machine == INTERTON || machine == ELEKTOR);

        // PVI tones
        psgpitch[6] = memory[I_PITCH];
        if (machine == ELEKTOR && (memory[0x1D07] & 0x40))
        {   psgvolume[6] = memory[0x1D0E] & 0xF;
        } else
        {   psgvolume[6] = 15;
        }
        // using I_NOISE to turn off PVI tone generator is not supported

        psgpitch[13] = memory[I_PITCH];
        if (memory[I_NOISE] & 0x10)
        {   psgvolume[13] = 15;
        } else
        {   psgvolume[13] = 0;
    }   }
    if (machine == ELEKTOR)
    {   // 1st PSG, output channel A
        if (!(memory[0x1D08] & 0x10))
        {   psgvolume[0] =
            psgvolume[7] = memory[0x1D08] & 0x0F;
        } else
        {   psgvolume[0] =
            psgvolume[7] = 0;
        }
        if (!(memory[0x1D07] &    1))
        {   psgpitch[0] = ((memory[0x1D01] & 0x0F) * 256) + memory[0x1D00];
        } else
        {   psgpitch[0] = 0;
        }
        if (!(memory[0x1D07] &    8))
        {   psgpitch[7] = memory[0x1D06] & 0x1F;
        } else
        {   psgpitch[7] = 0;
        }

        // 1st PSG, output channel B
        if (!(memory[0x1D09] & 0x10))
        {   psgvolume[1] =
            psgvolume[8] = memory[0x1D09] & 0x0F;
        } else
        {   psgvolume[1] =
            psgvolume[8] = 0;
        }
        if (!(memory[0x1D07] &    2))
        {   psgpitch[1] = ((memory[0x1D03] & 0x0F) * 256) + memory[0x1D02];
        } else
        {   psgpitch[1] = 0;
        }
        if (!(memory[0x1D07] & 0x10))
        {   psgpitch[8] = memory[0x1D06] & 0x1F;
        } else
        {   psgpitch[8] = 0;
        }

        // 1st PSG, output channel C
        if (!(memory[0x1D0A] & 0x10))
        {   psgvolume[2] =
            psgvolume[9] = memory[0x1D0A] & 0x0F;
        } else
        {   psgvolume[2] =
            psgvolume[9] = 0;
        }
        if (!(memory[0x1D07] &    4))
        {   psgpitch[2] = ((memory[0x1D05] & 0x0F) * 256) + memory[0x1D04];
        } else
        {   psgpitch[2] = 0;
        }
        if (!(memory[0x1D07] & 0x20))
        {   psgpitch[9] = memory[0x1D06] & 0x1F;
        } else
        {   psgpitch[9] = 0;
        }

        // 2nd PSG, output channel A
        if (!(memory[0x1D18] & 0x10))
        {   psgvolume[3] =
            psgvolume[10] = memory[0x1D18] & 0x0F;
        } else
        {   psgvolume[3] =
            psgvolume[10] = 0;
        }
        if (!(memory[0x1D17] &    1))
        {   psgpitch[3] = ((memory[0x1D11] & 0x0F) * 256) + memory[0x1D10];
        } else
        {   psgpitch[3] = 0;
        }
        if (!(memory[0x1D17] &    8))
        {   psgpitch[10] = memory[0x1D16] & 0x1F;
        } else
        {   psgpitch[10] = 0;
        }

        // 2nd PSG, output channel B
        if (!(memory[0x1D19] & 0x10))
        {   psgvolume[4]  =
            psgvolume[11] = memory[0x1D19] & 0x0F;
        } else
        {   psgvolume[4]  =
            psgvolume[11] = 0;
        }
        if (!(memory[0x1D17] &    2))
        {   psgpitch[4] = ((memory[0x1D13] & 0x0F) * 256) + memory[0x1D12];
        } else
        {   psgpitch[4] = 0;
        }
        if (!(memory[0x1D17] & 0x10))
        {   psgpitch[11] = memory[0x1D16] & 0x1F;
        } else
        {   psgpitch[11] = 0;
        }

        // 2nd PSG, output channel C
        if (!(memory[0x1D1A] & 0x10))
        {   psgvolume[5]  =
            psgvolume[12] = memory[0x1D1A] & 0x0F;
        } else
        {   psgvolume[5]  =
            psgvolume[12] = 0;
        }
        if (!(memory[0x1D17] &    4))
        {   psgpitch[5] = ((memory[0x1D15] & 0x0F) * 256) + memory[0x1D14];
        } else
        {   psgpitch[5] = 0;
        }
        if (!(memory[0x1D17] & 0x20))
        {   psgpitch[12] = memory[0x1D16] & 0x1F;
        } else
        {   psgpitch[12] = 0;
    }   }
    else
    {   psgpitch[0]   =
        psgpitch[1]   =
        psgpitch[2]   =
        psgpitch[3]   =
        psgpitch[4]   =
        psgpitch[5]   =
        psgpitch[7]   =
        psgpitch[8]   =
        psgpitch[9]   =
        psgpitch[10]  =
        psgpitch[11]  =
        psgpitch[12]  = 0;

        psgvolume[0]  =
        psgvolume[1]  =
        psgvolume[2]  =
        psgvolume[3]  =
        psgvolume[4]  =
        psgvolume[5]  =
        psgvolume[7]  =
        psgvolume[8]  =
        psgvolume[9]  =
        psgvolume[10] =
        psgvolume[11] =
        psgvolume[12] = 0;
     }

/*   0: 1st PSG, tone  channel A
     1: 1st PSG, tone  channel B
     2: 1st PSG, tone  channel C
     3: 2nd PSG, tone  channel A
     4: 2nd PSG, tone  channel B
     5: 2nd PSG, tone  channel C
     6: PVI/UVI tone generator
     7: 1st PSG, noise channel A
     8: 1st PSG, noise channel B
     9: 1st PSG, noise channel C
    10: 2nd PSG, noise channel A
    11: 2nd PSG, noise channel B
    12: 2nd PSG, noise channel C
    13: $1E80 noise generator, or UVI noise generator */

    for (i = 0; i <= 6; i++)
    {   if (psgpitch[i] && psgvolume[i])
        {   if
            (   force
             || !psgplaying[i]
             || psgpitch[i]  != oldpsgpitch[i]
             || psgvolume[i] != oldpsgvolume[i]
            )
            {   PSGStop(i);
                if (i == 6)
                {   hertz = (float)   7874.0 / (psgpitch[6] + 1); // desired frequency of the waveform
                } else
                {   hertz = (float) 110837.0 / (psgpitch[i]    ); // desired frequency of the waveform
                }
                TonePlay(i, hertz, psgvolume[i]);
                psgplaying[i] = TRUE;
        }   }
        else
        {   PSGStop(i);
    }   }

    for (i = 7; i <= 13; i++)
    {   if (psgpitch[i] && psgvolume[i])
        {   if
            (   force
             || !psgplaying[i]
             || psgvolume[i] != oldpsgvolume[i]
//           || psgpitch[i] != oldpsgpitch[i] (noise pitch isn't implemented)
            )
            {   PSGStop(i);
                NoisePlay(i, psgvolume[i]);
                psgplaying[i] = TRUE;
        }   }
        else
        {   PSGStop(i);
    }   }

    for (i = 0; i < 14; i++)
    {   oldpsgvolume[i] = psgvolume[i];
        oldpsgpitch[i]  = psgpitch[i];
}   }

EXPORT void macro_startrecording(void)
{   OPENFILENAME ofn;

    macro_stop();
    sound_off();
    if (!showpointer)
    {   ShowCursor(TRUE);
    }

    // this is order-dependent!
    split();
    if (machine == ARCADIA)
    {   fixextension_save(KIND_EAR);
    } elif (machine == INTERTON)
    {   fixextension_save(KIND_INR);
    } else
    {   // assert(machine == ELEKTOR);
        fixextension_save(KIND_TVR);
    }

    ZeroMemory(&ofn, sizeof(ofn));

    if (machine == ARCADIA)
    {   ofn.lpstrFilter = "Emerson Arcadia 2001 Recordings (*.EAR)\0*.EAR\0All Files (*.*)\0*.*\0";
        ofn.lpstrDefExt = "EAR";
    } elif (machine == INTERTON)
    {   ofn.lpstrFilter = "Interton VC 4000 Recordings (*.INR)\0*.INR\0All Files (*.*)\0*.*\0";
        ofn.lpstrDefExt = "INR";
    } else
    {   // assert(machine == ELEKTOR);
        ofn.lpstrFilter = "Elektor TV Games Computer Recordings (*.TVR)\0*.TVR\0All Files (*.*)\0*.*\0";
        ofn.lpstrDefExt = "TVR";
    }

    ofn.lStructSize = sizeof(ofn);
    ofn.hwndOwner = MainWindowPtr;
    ofn.lpstrFile = filepart;
    ofn.nMaxFile = MAX_PATH;
    ofn.Flags = OFN_EXPLORER | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
    ofn.lpstrInitialDir = (LPSTR) pathpart;

    clearkybd();
    if(!(GetSaveFileName(&ofn)))
    {   if (!showpointer)
        {   ShowCursor(FALSE);
        }
        // if (sound) sound_on(); not needed?
        return;
    } // implied else
    if (!showpointer)
    {   ShowCursor(FALSE);
    }
    // filepart now contains both path and filename
    strcpy(thefilename, filepart);

    /* Save EAR/INR/TVR */
    if (machine == ARCADIA)
    {   engine_save(KIND_EAR, TRUE);
    } elif (machine == INTERTON)
    {   engine_save(KIND_INR, TRUE);
    } else
    {   // assert(machine == ELEKTOR);
        engine_save(KIND_TVR, TRUE);
    }

    updatebiggads();
    updatesmlgads();
    updatemenus();
}

MODULE void maketoolbar(HWND hwnd)
{   TBBUTTON tbb[SMALLGADGETS];
    UINT images, gadgets;

    // We can't use MainWindowPtr, as it is not set up yet!
    // (This function gets called when the window is 'half-open'.)

    if (hToolbar)
    {   DestroyWindow(hToolbar);
        hToolbar = NULL;
    }
    if (LabelPtr)
    {   DestroyWindow(LabelPtr);
        LabelPtr = NULL;
    }
    if (FPSPtr)
    {   DestroyWindow(FPSPtr);
        FPSPtr = NULL;
    }

    if (!showtoolbar)
    {   return;
    }

    // Note that this assumes that there is enough width in fullscreen
    // mode to show the complete toolbar.
    if (fullscreen || (realwide >= 2 && realsize >= 2) || realsize >= 4)
    {   gadgets = SMALLGADGETS;
        images = SMALLIMAGES;
    } else
    {   gadgets = 3;
        images = 3;
    }

    ZeroMemory(tbb, sizeof(tbb));

    if (machine == ARCADIA)
    {   tbb[4].fsState  =
        tbb[5].fsState  =
        tbb[16].fsState = TBSTATE_ENABLED;
    } elif (machine == INTERTON)
    {   tbb[4].fsState  = TBSTATE_ENABLED;
        tbb[5].fsState  =
        tbb[16].fsState = 0; // not really needed, they will be 0 anyway
    } else
    {   // assert(machine == ELEKTOR);
        tbb[4].fsState  =
        tbb[5].fsState  =
        tbb[16].fsState = 0; // not really needed, they will be 0 anyway
    }

    tbb[0].iBitmap = 0;
    tbb[0].fsState = 0;
    tbb[0].fsStyle = TBSTYLE_BUTTON;
    tbb[0].idCommand = ID_FILE_RESET;
    tbb[1].iBitmap = 1;
    tbb[1].fsState = TBSTATE_ENABLED;
    tbb[1].fsStyle = TBSTYLE_BUTTON;
    tbb[1].idCommand = ID_FILE_OPEN;
    tbb[2].iBitmap = 2;
    tbb[2].fsState = 0;
    tbb[2].fsStyle = TBSTYLE_BUTTON;
    tbb[2].idCommand = ID_FILE_SAVESNP;

    tbb[3].iBitmap = 0;
    tbb[3].fsState = 0;
    tbb[3].fsStyle = TBSTYLE_SEP;
    tbb[3].idCommand = 0;

    tbb[4].iBitmap = 3;
    tbb[4].fsStyle = TBSTYLE_BUTTON;
    tbb[4].idCommand = ID_OPTIONS_GRAPHICS_FLAGLINE;
    tbb[5].iBitmap = 4;
    tbb[5].fsStyle = TBSTYLE_BUTTON;
    tbb[5].idCommand = ID_OPTIONS_GRAPHICS_VLOCK;

    tbb[6].iBitmap = 0;
    tbb[6].fsState = 0;
    tbb[6].fsStyle = TBSTYLE_SEP;
    tbb[6].idCommand = 0;

    tbb[7].iBitmap = 5;
    tbb[7].fsState = TBSTATE_ENABLED;
    tbb[7].fsStyle = TBSTYLE_CHECK;
    tbb[7].idCommand = ID_OPTIONS_CONTROLLERS_ANALOG;
    tbb[8].iBitmap = 6;
    tbb[8].fsState = TBSTATE_ENABLED;
    tbb[8].fsStyle = TBSTYLE_CHECK;
    tbb[8].idCommand = ID_OPTIONS_CONTROLLERS_AUTOFIRE;
    tbb[9].iBitmap = 7;
    tbb[9].fsState = TBSTATE_ENABLED;
    tbb[9].fsStyle = TBSTYLE_CHECK;
    tbb[9].idCommand = ID_OPTIONS_CONTROLLERS_SWAPPED;

    tbb[10].iBitmap = 0;
    tbb[10].fsState = 0;
    tbb[10].fsStyle = TBSTYLE_SEP;
    tbb[10].idCommand = 0;

    tbb[11].iBitmap = 8;
    tbb[11].fsState = TBSTATE_ENABLED;
    tbb[11].fsStyle = TBSTYLE_CHECK;
    tbb[11].idCommand = ID_OPTIONS_SPEED_PAUSED;
    tbb[12].iBitmap = 9;
    tbb[12].fsState = TBSTATE_ENABLED;
    tbb[12].fsStyle = TBSTYLE_CHECK;
    tbb[12].idCommand = ID_OPTIONS_SPEED_WARP;
    tbb[13].iBitmap = 10;
    tbb[13].fsState = TBSTATE_ENABLED;
    tbb[13].fsStyle = TBSTYLE_CHECK;
    tbb[13].idCommand = ID_OPTIONS_SPEED_REGION;

    tbb[14].iBitmap = 0;
    tbb[14].fsState = 0;
    tbb[14].fsStyle = TBSTYLE_SEP;
    tbb[14].idCommand = 0;

    tbb[15].iBitmap = 11;
    tbb[15].fsState = TBSTATE_ENABLED;
    tbb[15].fsStyle = TBSTYLE_CHECK;
    tbb[15].idCommand = ID_OPTIONS_SPRITES_COLLISIONS;
    tbb[16].iBitmap = 12;
    tbb[16].fsStyle = TBSTYLE_CHECK;
    tbb[16].idCommand = ID_OPTIONS_SPRITES_DEMULTIPLEX;

    tbb[17].iBitmap = 0;
    tbb[17].fsState = 0;
    tbb[17].fsStyle = TBSTYLE_SEP;
    tbb[17].idCommand = 0;

    tbb[18].iBitmap = 13;
    tbb[18].fsState = TBSTATE_ENABLED;
    tbb[18].fsStyle = TBSTYLE_CHECK;
    tbb[18].idCommand = ID_OPTIONS_SOUND;

    tbb[19].iBitmap = 0;
    tbb[19].fsState = 0;
    tbb[19].fsStyle = TBSTYLE_SEP;
    tbb[19].idCommand = 0;

    tbb[20].iBitmap = 14;
    tbb[20].fsState = 0;
    tbb[20].fsStyle = TBSTYLE_CHECK;
    tbb[20].idCommand = ID_MACRO_TOGGLEPLAYING;
    tbb[21].iBitmap = 15;
    tbb[21].fsState = 0;
    tbb[21].fsStyle = TBSTYLE_CHECK;
    tbb[21].idCommand = ID_MACRO_TOGGLERECORDING;

    // assert(hwnd);
    hToolbar = CreateToolbarEx
    (   hwnd,
        WS_CHILD | WS_VISIBLE | TBSTYLE_TOOLTIPS,
        IDC_TOOLBAR,
        images,
        GetModuleHandle(NULL),
        (UINT) MAKEINTRESOURCE(IDB_TOOLBAR),
        tbb,
        gadgets,
        18,
        18,
        18,
        18,
        sizeof(TBBUTTON)
    );
    if (hToolbar == NULL)
    {   MessageBox(MainWindowPtr, "Can't create toolbar!", "WinArcadia: Error", MB_OK | MB_ICONERROR);
        cleanexit(EXIT_FAILURE);
    }

    // Send the TB_BUTTONSTRUCTSIZE message, which is required
    SendMessage(hToolbar, TB_BUTTONSTRUCTSIZE, (WPARAM)sizeof(TBBUTTON), 0);
    SendMessage(hToolbar, TB_AUTOSIZE, 0, 0);
    updatebiggads();
    updatesmlgads();

    if (realsize >= 2 || realwide >= 2)
    {   if (!(LabelPtr = CreateWindowEx
        (   0, "STATIC",

#ifdef MODE_FPS
            "FPS:",
#else
            "CPS:",
#endif

            WS_CHILD | WS_VISIBLE | SS_RIGHT,

#ifdef MODE_FPS
            winwidth - 102, 8, 36, 18,
#else
            winwidth - 150, 8, 36, 18,
#endif

            hwnd, (HMENU) IDC_STATIC, GetModuleHandle(NULL), NULL
        )))
        {   MessageBox(MainWindowPtr, "Can't create static gadget!", "WinArcadia: Error", MB_OK | MB_ICONERROR);
            cleanexit(EXIT_FAILURE);
    }   }

#ifdef MODE_FPS
    oldfps = ~0;
    if (fps <= 9999)
    {   DISCARD stcul_d(fpsstring, fps);
    } else
    {   strcpy(fpsstring, "####");
    }
    if (!(FPSPtr = CreateWindowEx
    (   0, "STATIC", fpsstring,
        WS_CHILD | WS_VISIBLE | SS_CENTER,
        winwidth - 62, 8, 52, 18,
        hwnd, (HMENU) IDC_FPS, GetModuleHandle(NULL), NULL
    )))
    {   MessageBox(MainWindowPtr, "Can't create static gadget!", "WinArcadia: Error", MB_OK | MB_ICONERROR);
        cleanexit(EXIT_FAILURE);
    }
    /* That should instantly display the current FPS value, but for some reason it does not. */
#else
    if (realsize >= 2 || realwide >= 2)
    {   // WS_EX_CLIENTEDGE doesn't seem to work reliably
        if (!(FPSPtr = CreateWindowEx
        (   0, "STATIC", "-",
            WS_CHILD | WS_VISIBLE | SS_CENTER,
            winwidth - 110, 8, 100, 18,
            hwnd, (HMENU) IDC_FPS, GetModuleHandle(NULL), NULL
        )))
        {   MessageBox(MainWindowPtr, "Can't create static gadget!", "WinArcadia: Error", MB_OK | MB_ICONERROR);
            cleanexit(EXIT_FAILURE);
    }   }
#endif

    /* If we ask for a large window on a small screen, the window
       is truncated to fit. This will have, for example, the
       effect of the FPS display not being visible. */
}

EXPORT void settitle(void)
{   STRPTR filepart;

    if (machine == ARCADIA)
    {   strcpy(titlebartext, A_TITLEBARTEXT);
    } elif (machine == INTERTON)
    {   strcpy(titlebartext, I_TITLEBARTEXT);
    } else
    {   // assert(machine == ELEKTOR);
        strcpy(titlebartext, E_TITLEBARTEXT);
    }
    if (emulating && game)
    {   if (machine == INTERTON)
        {   DISCARD GetFullPathName(thefilename, MAX_PATH, &titlebartext[TITLEBARTEXTLENGTH    ], &filepart);
        } else
        {   // assert(machine == ARCADIA || machine == ELEKTOR);
            DISCARD GetFullPathName(thefilename, MAX_PATH, &titlebartext[TITLEBARTEXTLENGTH - 1], &filepart);
        }
        if (filepart)
        {   strcat(titlebartext, ": ");
            strcat(titlebartext, filepart);
    }   }
    SetWindowText(MainWindowPtr, titlebartext);

    // printf("Setting title to %s!\n", titlebartext);
}

MODULE FLAG ctrl(void)
{   if
    (   (KeyMatrix[SCAN_LCTRL  / 8] & (1 << (SCAN_LCTRL  % 8)))
     || (KeyMatrix[SCAN_RCTRL  / 8] & (1 << (SCAN_RCTRL  % 8)))
    )
    {   return TRUE;
    } else
    {   return FALSE;
}   }
MODULE FLAG shift(void)
{   if
    (   (KeyMatrix[SCAN_LSHIFT / 8] & (1 << (SCAN_LSHIFT % 8)))
     || (KeyMatrix[SCAN_RSHIFT / 8] & (1 << (SCAN_RSHIFT % 8)))
    )
    {   return TRUE;
    } else
    {   return FALSE;
}   }

EXPORT void openwindow(FLAG centre)
{   DWORD style;

    calcsize(FALSE);

    if (centre)
    {   winleftx = (DisplayWidth  / 2) - (winwidth  / 2);
        wintopy  = (DisplayHeight / 2) - (winheight / 2);
    }

    if (fullscreen)
    {   style = WS_POPUP | WS_MINIMIZEBOX /* | WS_MAXIMIZEBOX */ ;
    } else
    {   style = WS_POPUP | WS_MINIMIZEBOX /* | WS_MAXIMIZEBOX */ | WS_BORDER;
    }
    if (showmenubar)
    {   MenuPtr = LoadMenu(InstancePtr, MAKEINTRESOURCE(IDR_MAINMENU));
    } else
    {   MenuPtr = NULL;
    }
    if (showtitlebar)
    {   if (machine == ARCADIA)
        {   MainWindowPtr = CreateWindowEx(
                0,
                g_szClassName,
                A_TITLEBARTEXT,
                style | WS_CAPTION | WS_SYSMENU,
                winleftx, wintopy,
                winwidth, winheight,
                NULL,
                MenuPtr,
                InstancePtr, NULL);
        } elif (machine == INTERTON)
        {   MainWindowPtr = CreateWindowEx(
                0,
                g_szClassName,
                I_TITLEBARTEXT,
                style | WS_CAPTION | WS_SYSMENU,
                winleftx, wintopy,
                winwidth, winheight,
                NULL,
                MenuPtr,
                InstancePtr, NULL);
        } else
        {   // assert(machine == ELEKTOR);
            MainWindowPtr = CreateWindowEx(
                0,
                g_szClassName,
                E_TITLEBARTEXT,
                style | WS_CAPTION | WS_SYSMENU,
                winleftx, wintopy,
                winwidth, winheight,
                NULL,
                MenuPtr,
                InstancePtr, NULL);
    }   }
    else
    {   MainWindowPtr = CreateWindowEx(
            0,
            g_szClassName,
            NULL,
            style,
            winleftx, wintopy,
            winwidth, winheight,
            NULL,
            MenuPtr,
            InstancePtr, NULL);
    }

    if(MainWindowPtr == NULL)
    {   MessageBox(NULL, "Window creation failed!", "WinArcadia: Error", MB_ICONEXCLAMATION | MB_OK);
        cleanexit(EXIT_FAILURE);
    }

    joy[0] = joy[1] = FALSE;
    if (joySetCapture(MainWindowPtr, JOYSTICKID1, 0, FALSE) == JOYERR_NOERROR)
    {   joy[1] = TRUE;
    }
    if (joySetCapture(MainWindowPtr, JOYSTICKID2, 0, FALSE) == JOYERR_NOERROR)
    {   joy[0] = TRUE;
    }
    // captures are automatically released when window is destroyed.

    DragAcceptFiles(MainWindowPtr, TRUE);
    ShowWindow(MainWindowPtr, SW_SHOW);
    UpdateWindow(MainWindowPtr);
    // MenuPtr = GetMenu(MainWindowPtr);

    updatebiggads();
    updatesmlgads();
    updatemenus();
    redrawscreen();
    settitle();

    if (fps <= 9999)
    {   DISCARD stcul_d(fpsstring, fps);
    } else
    {   strcpy(fpsstring, "####");
    }
    DISCARD SetWindowText(FPSPtr, fpsstring);
}

EXPORT void closewindow(void)
{   SetMenu(MainWindowPtr, MenuPtr); // so it is automatically freed for us
    // PostMessage(MainWindowPtr, WM_CLOSE, 0, 0);
    DestroyWindow(MainWindowPtr);
    MainWindowPtr = NULL;
}

/* MODULE FLAG getargv[i](LPSTR lpCmdLine)
{   AUTO    ULONG destwhere = 0;
    PERSIST ULONG srcwhere  = 0;

    while
    (   lpCmdLine[srcwhere] == ' '
     || lpCmdLine[srcwhere] == '\t'
    )
    {   srcwhere++;
    }
    if (lpCmdLine[srcwhere] == 0)
    {   return FALSE;
    }
    while
    (   lpCmdLine[srcwhere] != ' '
     && lpCmdLine[srcwhere] != '\t'
     && lpCmdLine[srcwhere] != 0
    )
    {   argv[i][destwhere++] = lpCmdLine[srcwhere++];
    }
    argv[i][destwhere] = 0;

    return TRUE;
} */

MODULE void printusage(STRPTR progname)
{   OPENCONSOLE;
    printf(
                   "Usage: %s\n"
             "[[FILE]=<file>]\n"
             "[ANALOG=ON|OFF]\n"
           "[AUTOFIRE=ON|OFF]\n"
           "[AUTOSAVE=ON|OFF]\n"
      "[BREAKPOINT|BP=<address>]\n"
         "[COLLISIONS=ON|OFF]\n"
        "[DEMULTIPLEX=ON|OFF]\n"
           "[FLAGLINE=ON|OFF]\n"
         "[FULLSCREEN=ON|OFF]\n"
       "[LIMITREFRESH=ON|OFF]\n"
    "[LOGINSTRUCTIONS=ON|OFF]\n"
           "[LOGREADS=ON|OFF]\n"
          "[LOGWRITES=ON|OFF]\n"
            "[MACHINE=ARCADIA|INTERTON|ELEKTOR]\n"
            "[MENUBAR=ON|OFF]\n"
             "[NARROW=ON|OFF]\n"
             "[PAUSED=ON|OFF]\n"
               "[SIZE=1|2|3]\n"
              "[SOUND=ON|OFF]\n"
            "[STRETCH=ON|OFF]\n"
            "[SWAPPED=ON|OFF]\n"
           "[TITLEBAR=ON|OFF]\n"
            "[TOOLBAR=ON|OFF]\n"
              "[VLOCK=ON|OFF]\n"
               "[WARP=ON|OFF]\n"
      "[WATCHPOINT|WP=<address>]\n"
             , progname
    );

    cleanexit(EXIT_FAILURE);
}

MODULE void debug_change(void)
{   if (emulating)
    {   if (sound) sound_off();
        DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_CHANGE), MainWindowPtr, ChangeDlgProc);
        if (sound) sound_on();
}   }

BOOL CALLBACK ChangeDlgProc(HWND hwnd, UINT Message, WPARAM wParam, LPARAM lParam)
{   PERSIST FLAG dontaddr,
                 dontto;

    // IAR and RAS0..RAS7 are allowed to be up to 32767.
    // All others are limited to 255.

    switch(Message)
    {
    case WM_INITDIALOG:
        tolimit = 255;
        SetWindowText(GetDlgItem(hwnd, IDC_CHANGE_ADDRESS), "");
        fromstr[0] = 0;
        SetWindowText(GetDlgItem(hwnd, IDC_CHANGE_FROM), fromstr);
        dontto = dontaddr = FALSE;

        return TRUE;
    break;
    case WM_CLOSE:
        change_write(globalstring);
        clearkybd();
        EndDialog(hwnd, 0);

        return TRUE;
    break;
    case WM_COMMAND:
        if (LOWORD (wParam) == IDOK)
        {   // assert(tonum >= 0 && tonum <= tolimit);
            change_write(globalstring);
            clearkybd();
            EndDialog(hwnd, 0);

            return TRUE;
        }
        if (LOWORD (wParam) == IDCANCEL)
        {   // OPENCONSOLE;
            // printf("Cancelled!\n\n");
            // REACTIVATE;
            clearkybd();
            EndDialog(hwnd, 0);

            return TRUE;
        }
        if (HIWORD (wParam) == EN_UPDATE)
        {   if (LOWORD (wParam) == IDC_CHANGE_TO)
            {   if (dontto)
                {   dontto = FALSE;
                } else
                {   GetWindowText(GetDlgItem(hwnd, IDC_CHANGE_TO), tostr, sizeof(tostr));
                    if (strlen(tostr) > 5) // "$7FFF" or "32767"
                    {   tostr[5] = 0;
                        dontto = TRUE;
                        SetWindowText(GetDlgItem(hwnd, IDC_CHANGE_TO), tostr);
                    }
                    // maybe we should check for illegal chars?
                    if (tostr[0] == '$')
                    {   stch_l(&tostr[1], &tonum); // hexstring -> number
                    } else
                    {   stcd_l(tostr, &tonum); // decstring -> number
                    }
                    if (tonum < 0 || tonum > tolimit)
                    {   tonum = 0;
                        if (tolimit == 255)
                        {   strcpy(tostr, "$00");
                        } else
                        {   // assert(tolimit == 32767);
                            strcpy(tostr, "$0000");
                        }
                        dontto = TRUE;
                        SetWindowText(GetDlgItem(hwnd, IDC_CHANGE_TO), tostr);
            }   }   }
            elif (LOWORD (wParam) == IDC_CHANGE_ADDRESS)
            {   if (dontaddr)
                {   dontaddr = FALSE;
                } else
                {   GetWindowText(GetDlgItem(hwnd, IDC_CHANGE_ADDRESS), globalstring, sizeof(globalstring));
                    if (strlen(globalstring) > 13) // eg. "SPRITECOLLIDE"
                    {   globalstring[13] = 0;
                        dontaddr = TRUE;
                        SetWindowText(GetDlgItem(hwnd, IDC_CHANGE_ADDRESS), globalstring);
                    }

                    change_read(globalstring);
                    SetWindowText(GetDlgItem(hwnd, IDC_CHANGE_FROM), fromstr);
                    SetWindowText(GetDlgItem(hwnd, IDC_CHANGE_TO  ),   tostr);
        }   }   }

        return FALSE;
    break;
    default:
        return FALSE;
    }
    return TRUE;
}

EXPORT void openconsole(void)
{   int   hCrt;
    FILE* hf;

    // assert(consoleopen);

    AllocConsole(); // might need freeing at program exit
    consoleopen = TRUE;
    hCrt = _open_osfhandle((long) GetStdHandle(STD_OUTPUT_HANDLE), _O_TEXT); // might need freeing at program exit
    hf = _fdopen( hCrt, "w" ); // might need freeing at program exit
    *stdout = *hf;
    DISCARD setvbuf( stdout, NULL, _IONBF, 0 );
}

// Splits a complete pathname (in thefilename) into pathpart and filepart.

MODULE void split(void)
{   signed int   where,
                 thelength,
                 i;

    strcpy(pathpart, thefilename);
    where = -1;
    thelength = strlen(thefilename);
    for (i = 0; i < thelength; i++)
    {   if
        (   thefilename[i] == ':'
         || thefilename[i] == '\\'
        )
        {   where = i;
            // don't break, we want the LAST component, not the FIRST
    }   }
    strcpy(filepart, &thefilename[where + 1]);
    pathpart[where + 1] = 0;
}

MODULE void handlekybd(UINT code)
{   int i;

    // Note that where certain key qualifiers are unused, they are
    // ignored. Eg. Ctrl-Shift-E is the same as Ctrl-E.

    switch(code)
    {
    case SCAN_ESCAPE:
        cleanexit(EXIT_SUCCESS);
    acase SCAN_BACKSPACE:
        if (trace) trace = FALSE; else trace = TRUE;
        docommand(MENUITEM_TRACECPU);
    acase SCAN_RETURN:
        docommand(MENUITEM_STEP);
	acase SCAN_BACKTICK:
	    if (ctrl())
		{	if (watchreads) watchreads = FALSE; else watchreads = TRUE;
            updatemenu(MENUITEM_WATCHREADS);
        }   	
	acase SCAN_A:
        if (ctrl())
        {   docommand(MENUITEM_SAVEROM);
        } else
        {   KeyMatrix[code / 8] |= (1 << (code % 8));
        }
    acase SCAN_B:
        if (ctrl())
        {   if (showtitlebar) showtitlebar = FALSE; else showtitlebar = TRUE; // foo = ~foo; doesn't always work!
            docommand(MENUITEM_TITLEBAR);
        }
    acase SCAN_F12:
        if (ControlsWindowPtr)
        {   DestroyWindow(ControlsWindowPtr);
            ControlsWindowPtr = NULL;
            unghost(MENUITEM_CONTROLS);
        } else
        {   ghost(MENUITEM_CONTROLS);
            for (i = 0; i < KEYS; i++)
            {   oldkeys[i] = 0;
            }
            if (machine == INTERTON)
            {   controlstype = INTERTON;
                ControlsWindowPtr = CreateDialog
                (   InstancePtr,                    // handle to application instance
                    MAKEINTRESOURCE(IDD_ICONTROLS), // identifies dialog box template name
                    MainWindowPtr,
                    ControlsDlgProc
                );
            } else
            {   // assert(machine == ARCADIA || machine == ELEKTOR);
                controlstype = ARCADIA;
                ControlsWindowPtr = CreateDialog
                (   InstancePtr,                    // handle to application instance
                    MAKEINTRESOURCE(IDD_ACONTROLS), // identifies dialog box template name
                    MainWindowPtr,
                    ControlsDlgProc
                );
            }
            SetActiveWindow(MainWindowPtr);
        }
    acase SCAN_C:
        if (ctrl())
        {   if (ControlsWindowPtr)
            {   DestroyWindow(ControlsWindowPtr);
                ControlsWindowPtr = NULL;
                unghost(MENUITEM_CONTROLS);
            } else
            {   ghost(MENUITEM_CONTROLS);
                for (i = 0; i < KEYS; i++)
                {   oldkeys[i] = 0;
                }
                if (machine == INTERTON)
                {   ControlsWindowPtr = CreateDialog
                    (   InstancePtr,                    // handle to application instance
                        MAKEINTRESOURCE(IDD_ICONTROLS), // identifies dialog box template name
                        MainWindowPtr,
                        ControlsDlgProc
                    );
                } else
                {   // assert(machine == ARCADIA || machine == ELEKTOR);
                    ControlsWindowPtr = CreateDialog
                    (   InstancePtr,                    // handle to application instance
                        MAKEINTRESOURCE(IDD_ACONTROLS), // identifies dialog box template name
                        MainWindowPtr,
                        ControlsDlgProc
                    );
                }
                SetActiveWindow(MainWindowPtr);
        }   }
        else
        {   KeyMatrix[code / 8] |= (1 << (code % 8));
        }
    acase SCAN_E: // clear watchpoint
        if (ctrl())
        {   debug_clearwp();
        } else
        {   KeyMatrix[code / 8] |= (1 << (code % 8));
        }
    acase SCAN_F:
        if (ctrl())
        {   if (fullscreen)
            {   if (stretch)
                {   stretch = FALSE;
                } else
                {   stretch = TRUE;
                }
                updatemenu(MENUITEM_STRETCH);
                redrawscreen();
        }   }
        else
        {   KeyMatrix[code / 8] |= (1 << (code % 8));
        }
    acase SCAN_G: // set breakpoint
        if (ctrl())
        {   debug_set(KIND_BP);
        }
    acase SCAN_H: // clear breakpoint
        if (ctrl())
        {   debug_clearbp();
        } else
        {   KeyMatrix[code / 8] |= (1 << (code % 8));
        }
    acase SCAN_K:
        if (ctrl())
        {   debug_change();
        } else
        {   KeyMatrix[code / 8] |= (1 << (code % 8));
        }
    acase SCAN_L:
        if (ctrl())
        {   if (showtoolbar) showtoolbar = FALSE; else showtoolbar = TRUE; // foo = ~foo; doesn't always work!
            docommand(MENUITEM_TOOLBAR);
        } else
        {   KeyMatrix[code / 8] |= (1 << (code % 8));
        }
    acase SCAN_M:
        if (ctrl())
        {   if (showmenubar) showmenubar = FALSE; else showmenubar = TRUE; // foo = ~foo; doesn't always work!
            // no point in doing updatemenu(MENUITEM_MENUBAR);
            closewindow();
            if (!fullscreen)
			{	winleftx -= 3;
			}
            openwindow(FALSE);
            redrawscreen();
        }
    acase SCAN_N:
        if (ctrl() && !fullscreen)
        {   if (wide == 1)
            {   wide = realwide = 2;
            } else
            {   // assert(wide == 2);
                wide = realwide = 1;
            }
            updatemenu(MENUITEM_NARROW);
            resize(size);
        }
    acase SCAN_O:
        if (!crippled && ctrl())
        {   project_open();
        }
    acase SCAN_P:
        if (ctrl())
        {   if (flagline) flagline = FALSE; else flagline = TRUE; // foo = ~foo; doesn't always work!
            updatesmlgad(GADPOS_FLAGLINE, flagline, TRUE);
            updatemenu(MENUITEM_FLAGLINE);
            if (emulating && paused)
            {   redrawscreen();
        }   }
        else // paused ('P' key)
        {   if (paused)
            {   unpause();
            } else
            {   pause();
        }   }
    acase SCAN_R:
        if (ctrl())
        {   if (emulating)
            {   macro_startrecording();
        }   }
        else
        {   KeyMatrix[code / 8] |= (1 << (code % 8));
        }
    acase SCAN_S:
        if (ctrl())
        {   if (emulating && !crippled)
            {   if (machine == ARCADIA)
                {   DISCARD project_save(KIND_EAS);
                } elif (machine == INTERTON)
                {   DISCARD project_save(KIND_INS);
                } else
                {   // assert(machine == ELEKTOR);
                    DISCARD project_save(KIND_TVS);
        }   }   }
        else
        {   KeyMatrix[code / 8] |= (1 << (code % 8));
        }
    acase SCAN_T:
        if (ctrl())
        {   if (emulating)
            {   macro_stop();
        }   }
    acase SCAN_U:
        if (ctrl())
        {   if (sound) sound = FALSE; else sound = TRUE; // foo = ~foo; doesn't always work!
            docommand(MENUITEM_SOUND);
        }
    acase SCAN_V:
        if (ctrl())
        {   if (autosave) autosave = FALSE; else autosave = TRUE; // foo = ~foo; doesn't always work!
            updatemenu(MENUITEM_AUTOSAVE);
        } else
        {   KeyMatrix[code / 8] |= (1 << (code % 8));
        }
    acase SCAN_W:
        if (ctrl())
        {   debug_set(KIND_WP);
        } else
        {   KeyMatrix[code / 8] |= (1 << (code % 8));
        }
    acase SCAN_X:
        if (ctrl())
        {   if (showpointer) showpointer = FALSE; else showpointer = TRUE;
            docommand(MENUITEM_POINTER);
        } else
        {   KeyMatrix[code / 8] |= (1 << (code % 8));
        }
    acase SCAN_Y:
        if (ctrl())
        {   if (loop) loop = FALSE; else loop = TRUE; // foo = ~foo; doesn't always work!
            docommand(MENUITEM_LOOP);
        }
    acase SCAN_Z:
        if (ctrl())
        {   docommand(MENUITEM_STEP);
        } else
        {   KeyMatrix[code / 8] |= (1 << (code % 8));
        }
    acase SCAN_F1:
    case SCAN_A1:
        if (ctrl())
        {   if (shift())
            {   runtorastline = TRUE;
                unpause();
            } else
            {   if (!fullscreen && size != 1)
                {   resize(1);
        }   }   }
        else
        {   KeyMatrix[code / 8] |= (1 << (code % 8));
        }
    acase SCAN_F2:
    case SCAN_A2:
        if (ctrl())
        {   if (shift())
            {   if (machine == ARCADIA)
                {   runtodma = TRUE;
                    unpause();
            }   }
            else
            {   if (!fullscreen && size != 2)
                {   resize(2);
        }   }   }
        else
        {   KeyMatrix[code / 8] |= (1 << (code % 8));
        }
    acase SCAN_F3:
    case SCAN_A3:
        if (ctrl())
        {   if (shift())
            {   runtoframe = TRUE;
                unpause();
            } else
            {   if (!fullscreen && size != 3)
                {   resize(3);
        }   }   }
        else
        {   KeyMatrix[code / 8] |= (1 << (code % 8));
        }
    acase SCAN_A4:
        if (ctrl())
        {   if (shift())
            {   if (logreads) logreads = FALSE; else logreads = TRUE; // foo = ~foo; doesn't always work!
                updatemenu(MENUITEM_LOGREADS);
            } else
            {   view_cram();
        }   }
        else
        {   KeyMatrix[code / 8] |= (1 << (code % 8));
        }
    acase SCAN_F5:
        if (!crippled)
        {   if (shift())
			{	if (machine == ELEKTOR)
				{	// assert(emulating);
			        iar = 0;
			}	}
			else
			{	project_reset();
        }	}
    acase SCAN_A5:
        if (ctrl())
        {   if (shift())
            {   if (logwrites) logwrites = FALSE; else logwrites = TRUE; // foo = ~foo; doesn't always work!
                updatemenu(MENUITEM_LOGWRITES);
            } else
            {   view_mram();
        }   }
    acase SCAN_F6: // monitor
        if (MonitorWindowPtr)
        {   DestroyWindow(MonitorWindowPtr);
            MonitorWindowPtr = NULL;
            unghost(MENUITEM_MONITOR);
        } else
        {   ghost(MENUITEM_MONITOR);
            if (machine == ARCADIA)
            {   MonitorWindowPtr = CreateDialog
                (   InstancePtr,                   // handle to application instance
                    MAKEINTRESOURCE(IDD_AMONITOR), // identifies dialog box template name
                    MainWindowPtr,
                    MonitorDlgProc
                );
            } elif (machine == INTERTON)
            {   MonitorWindowPtr = CreateDialog
                (   InstancePtr,                   // handle to application instance
                    MAKEINTRESOURCE(IDD_IMONITOR), // identifies dialog box template name
                    MainWindowPtr,
                    MonitorDlgProc
                );
            } else
            {   // assert(machine == ELEKTOR);
                MonitorWindowPtr = CreateDialog
                (   InstancePtr,                   // handle to application instance
                    MAKEINTRESOURCE(IDD_EMONITOR), // identifies dialog box template name
                    MainWindowPtr,
                    MonitorDlgProc
                );
            }

            monitortype = machine;
            initmonitor();
        }
    acase SCAN_A6:
        if (ctrl())
        {   if (shift())
            {   if (limitrefresh) limitrefresh = FALSE; else limitrefresh = TRUE; // foo = ~foo; doesn't always work!
                updatemenu(MENUITEM_LIMITREFRESH);
            } else
            {   view_upperscreen();
        }   }
        else // analog ('6' key)
        {   if (analog) analog = FALSE; else analog = TRUE; // foo = ~foo; doesn't always work!
            updatesmlgad(GADPOS_ANALOG, analog, TRUE);
            updatemenu(MENUITEM_ANALOG);
        }
    acase SCAN_F7: // swap paddles ('F7' key)
        if (swapped) swapped = FALSE; else swapped = TRUE; // foo = ~foo; doesn't always work!
        updatesmlgad(GADPOS_SWAPPED, swapped, TRUE);
        updatemenu(MENUITEM_SWAPPED);
    acase SCAN_A7:
        if (ctrl())
        {   if (shift())
            {   docommand(COMMAND_ARCADIA);
            } else
            {   view_udcs();
        }   }
    acase SCAN_F8: // warp ('F8' key)
        if (warp)
        {   warp = FALSE;
            waittill = timeGetTime(); // makes it effectively IMMEDIATELY
        } else warp = TRUE; // foo = ~foo; doesn't always work!
        updatesmlgad(GADPOS_WARP, warp, TRUE);
        updatemenu(MENUITEM_WARP);
    acase SCAN_A8:
        if (ctrl())
        {   if (shift())
            {   docommand(COMMAND_INTERTON);
            } else
            {   view_xvi();
        }   }
        else // demultiplex ('8' key)
        {   if (machine == ARCADIA)
            {   if (demultiplex) demultiplex = FALSE; else demultiplex = TRUE; // foo = ~foo; doesn't always work!
                docommand(MENUITEM_DEMULTIPLEX);
        }   }
    acase SCAN_F9:
        if (fullscreen) fullscreen = FALSE; else fullscreen = TRUE; // foo = ~foo; doesn't always work!
        updatemenu(MENUITEM_FULLSCREEN);
        closewindow();
        openwindow(TRUE);
        redrawscreen();
    acase SCAN_A9: // collisions ('9' key)
        if (ctrl())
        {   if (shift())
            {   docommand(COMMAND_ELEKTOR);
            } else
            {   view_cpu();
        }   }
        else
        {   if (collisions) collisions = FALSE; else collisions = TRUE; // foo = ~foo; doesn't always work!
            updatesmlgad(GADPOS_COLLISIONS, collisions, TRUE);
            updatemenu(MENUITEM_COLLISIONS);
        }
    acase SCAN_A0: // autofire ('0' key)
        if (ctrl())
        {   if (shift())
            {   debug_setrastn();
                unpause();
            } elif (machine == ARCADIA)
            {   view_lowerscreen();
        }   }
        else
        {   if (autofire) autofire = FALSE; else autofire = TRUE; // foo = ~foo; doesn't always work!
            updatesmlgad(GADPOS_AUTOFIRE, autofire, TRUE);
            updatemenu(MENUITEM_AUTOFIRE);
        }
    acase SCAN_HYPHEN:
        if (ctrl())
        {   if (shift)
			{	if (emulating && !crippled && recmode == RECMODE_PLAY)
				{	macro_restartplayback();
			}	}
			else
			{	if (loginstructions) loginstructions = FALSE; else loginstructions = TRUE;
				docommand(MENUITEM_LOGINSTRUCTIONS);
        }	}
    acase SCAN_EQUALS:
        if (ctrl())
        {   view_allmemory();
        }
    acase SCAN_FULLSTOP:
        if (ctrl() && machine == ELEKTOR)
        {   view_psgs();
        }
    acase SCAN_BACKSLASH:
        if (ctrl())
        {   if (machine == ELEKTOR)
            {   // assert(emulating);
                project_save(KIND_TVC);
        }   }
    acase SCAN_OS:
        if (ctrl())
        {   region = REGION_NTSC;
            docommand(COMMAND_REGION);
        }
    acase SCAN_CS:
        if (ctrl())
        {   region = REGION_PAL;
            docommand(COMMAND_REGION);
        }
    acase SCAN_COMMA:
        if (ctrl())
		{	if (machine == ELEKTOR && !crippled)
			{	// assert(emulating);
			    iar = 0;
		}	}
		elif (machine == ARCADIA)
        {   if (vlock) vlock = FALSE; else vlock = TRUE; // foo = ~foo; doesn't always work!
            updatesmlgad(GADPOS_VLOCK, vlock, TRUE);
            updatemenu(MENUITEM_VLOCK);
            if (emulating && paused)
            {   redrawscreen();
        }   }
    acase SCAN_SLASH:
        if (ctrl() && shift())
        {   if (sound) sound_off();
            DialogBox(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_ABOUT), MainWindowPtr, HelpDlgProc);
            if (sound) sound_on();
        }
    acase SCAN_LCTRL:
    case SCAN_RCTRL:
    case SCAN_LSHIFT:
    case SCAN_RSHIFT:
        KeyMatrix[code / 8] |= (1 << (code % 8));
    adefault:
        if (!(ctrl()) && !(shift()))
        {   KeyMatrix[code / 8] |= (1 << (code % 8));
        }
    break;
}   }

MODULE void clearkybd(void)
{   KeyMatrix[SCAN_LCTRL  / 8] &= ~(1 << (SCAN_LCTRL  % 8));
    KeyMatrix[SCAN_RCTRL  / 8] &= ~(1 << (SCAN_RCTRL  % 8));
    KeyMatrix[SCAN_LSHIFT / 8] &= ~(1 << (SCAN_LSHIFT % 8));
    KeyMatrix[SCAN_RSHIFT / 8] &= ~(1 << (SCAN_RSHIFT % 8));
}

EXPORT void reactivate(void)
{   // for some reason, this doesn't work the first time, but does for subsequent times!
    SetFocus(MainWindowPtr);
}

EXPORT void updatebiggads(void)
{   if (!emulating || crippled)
    {   SendMessage(hToolbar, TB_SETSTATE, ID_FILE_RESET,        0);
        SendMessage(hToolbar, TB_SETSTATE, ID_FILE_SAVESNP,      0);
    } else
    {   SendMessage(hToolbar, TB_SETSTATE, ID_FILE_RESET,        TBSTATE_ENABLED);
        SendMessage(hToolbar, TB_SETSTATE, ID_FILE_SAVESNP,      TBSTATE_ENABLED);
    }
    if (crippled)
    {   SendMessage(hToolbar, TB_SETSTATE, ID_FILE_OPEN,         0);
    } else
    {   SendMessage(hToolbar, TB_SETSTATE, ID_FILE_OPEN,         TBSTATE_ENABLED);
    }
    DISCARD RedrawWindow(FPSPtr, NULL, NULL, RDW_INVALIDATE | RDW_UPDATENOW);
}

EXPORT void ghost(int which)
{   if (menucode[which] != -1)
    {   DISCARD EnableMenuItem(MenuPtr, menucode[which], MF_BYCOMMAND | MF_GRAYED);
}   }
EXPORT void unghost(int which)
{   if (menucode[which] != -1)
    {   DISCARD EnableMenuItem(MenuPtr, menucode[which], MF_BYCOMMAND | MF_ENABLED);
}   }
EXPORT void tick(int which)
{   if (menucode[which] != -1)
    {   DISCARD CheckMenuItem(MenuPtr, menucode[which], MF_BYCOMMAND | MF_CHECKED);
}   }
EXPORT void untick(int which)
{   if (menucode[which] != -1)
    {   DISCARD CheckMenuItem(MenuPtr, menucode[which], MF_BYCOMMAND | MF_UNCHECKED);
}   }
EXPORT void setbutton(int which, FLAG enabled, FLAG state)
{   if (gadgetcode[which] != -1)
    {   if (!enabled)
        {   if (state)
            {   SendMessage(hToolbar, TB_SETSTATE, gadgetcode[which], TBSTATE_CHECKED);
            } else
            {   SendMessage(hToolbar, TB_SETSTATE, gadgetcode[which], 0);
        }   }
        else
        {   if (state)
            {   SendMessage(hToolbar, TB_SETSTATE, gadgetcode[which], TBSTATE_ENABLED | TBSTATE_CHECKED);
            } else
            {   SendMessage(hToolbar, TB_SETSTATE, gadgetcode[which], TBSTATE_ENABLED);
}   }   }   }

EXPORT void say(STRPTR text)
{   MessageBox(MainWindowPtr, text, "WinArcadia: Warning", MB_OK | MB_ICONEXCLAMATION);
}

EXPORT void infowindow(STRPTR text)
{   MessageBox(MainWindowPtr, text, "WinArcadia: Information", MB_OK | MB_ICONINFORMATION);
}
